package cn.com.duibaboot.ext.autoconfigure.zuul;

import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import org.springframework.web.util.pattern.PathPattern;
import reactor.core.publisher.Mono;

/**
 * for webflux/reactive
 */
public class DuibaZuulReactiveFilter implements WebFilter {

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        exchange.getResponse().beforeCommit(() -> Mono.fromRunnable(() -> {
            if("true".equals(exchange.getRequest().getHeaders().getFirst(DuibaZuulAutoConfiguration.X_VIA_ZUUL))
                    && !"/error".equals(exchange.getRequest().getURI().getPath())){
                PathPattern pathPattern = exchange.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
                String path = pathPattern == null ? null : pathPattern.getPatternString();
                if (path != null && !"/**".equals(path)) {
                    exchange.getResponse().getHeaders().add(DuibaZuulAutoConfiguration.X_MATCH_PATH, path);
                }
            }
        }));

        return chain.filter(exchange);
    }
}
