/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import cn.com.duiba.wolf.utils.ConcurrentUtils;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.DevRibbonServerListFilter;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.PerfTestRibbonServerListFilter;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.RibbonLoadBalancerClientBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.ServiceGroupRibbonServerListFilter;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.loadbalancer.IpAffinityServerListFilter;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.IPingStrategy;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.Server;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.reactive.context.ReactiveWebApplicationContext;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.cloud.netflix.ribbon.RibbonApplicationContextInitializer;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.openfeign.CustomFeignClientsRegistrar;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.context.WebApplicationContext;

@Configuration
@ConditionalOnClass(value={IPing.class, IRule.class, ILoadBalancer.class, IPingStrategy.class})
public class RibbonCustomAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(RibbonCustomAutoConfiguration.class);
    @Resource
    private SpringClientFactory springClientFactory;
    @Autowired
    private ObjectProvider<List<RibbonApplicationContextInitializer>> ribbonApplicationContextInitializersProvider;

    @EventListener(value={MainContextRefreshedEvent.class})
    @Order(value=-2147483648)
    public void onMainContextRefreshed() {
        long start = System.currentTimeMillis();
        List list = (List)this.ribbonApplicationContextInitializersProvider.getIfAvailable();
        if (list != null) {
            list.forEach(ribbonApplicationContextInitializer -> ribbonApplicationContextInitializer.onApplicationEvent(null));
        }
        long cost = System.currentTimeMillis() - start;
        logger.info("ribbon context initted in {}ms", (Object)cost);
    }

    @Bean
    public ApplicationListener<ContextRefreshedEvent> springClientFactoryInitListener() {
        return new ApplicationListener<ContextRefreshedEvent>(){

            public void onApplicationEvent(ContextRefreshedEvent event) {
                if (event.getApplicationContext() instanceof WebApplicationContext || event.getApplicationContext() instanceof ReactiveWebApplicationContext) {
                    Set<String> enabledFeignClientNames = CustomFeignClientsRegistrar.getEnabledFeignClientNames();
                    for (String name : enabledFeignClientNames) {
                        RibbonCustomAutoConfiguration.this.springClientFactory.getClientConfig(name);
                    }
                }
            }
        };
    }

    @Bean
    public IPingStrategy getConcurrentRibbonPingStrategy() {
        return new ConcurrentPingStrategy();
    }

    @Bean
    public ApplicationListener<ContextRefreshedEvent> iLoadBalancerInitListener() {
        return new ApplicationListener<ContextRefreshedEvent>(){

            public void onApplicationEvent(ContextRefreshedEvent event) {
                try {
                    ILoadBalancer bean = (ILoadBalancer)event.getApplicationContext().getBean(ILoadBalancer.class);
                    Field pingStrategyField = ReflectionUtils.findField(bean.getClass(), (String)"pingStrategy");
                    if (pingStrategyField != null) {
                        pingStrategyField.setAccessible(true);
                        ReflectionUtils.setField((Field)pingStrategyField, (Object)bean, (Object)RibbonCustomAutoConfiguration.this.getConcurrentRibbonPingStrategy());
                    } else {
                        logger.error("[NOTIFYME]ILoadBalancer\u4e2d\u7684pingStrategy Field\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u4f7f\u7528\u5e76\u53d1ping\u7b56\u7565");
                    }
                }
                catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                    // empty catch block
                }
            }
        };
    }

    @Bean
    @Profile(value={"dev"})
    public DevRibbonServerListFilter devRibbonServerListFilter() {
        return new DevRibbonServerListFilter(true);
    }

    @Bean
    public PerfTestRibbonServerListFilter perfTestRibbonServerListFilter() {
        return new PerfTestRibbonServerListFilter();
    }

    @Bean
    @RefreshScope
    public IpAffinityServerListFilter ipAffinityServerListFilter() {
        return new IpAffinityServerListFilter();
    }

    @Bean
    public ServiceGroupRibbonServerListFilter serviceGroupRibbonServerListFilter() {
        return new ServiceGroupRibbonServerListFilter();
    }

    @Bean
    public static RibbonLoadBalancerClientBeanPostProcessor ribbonLoadBalancerClientBeanPostProcessor() {
        return new RibbonLoadBalancerClientBeanPostProcessor();
    }

    private static class ConcurrentPingStrategy
    implements IPingStrategy,
    DisposableBean {
        private final ExecutorService executor = Executors.newFixedThreadPool(20, (ThreadFactory)new NamedThreadFactory("ribbonPing"));
        private static final Logger logger = LoggerFactory.getLogger(ConcurrentPingStrategy.class);

        private ConcurrentPingStrategy() {
        }

        public boolean[] pingServers(IPing ping, Server[] servers) {
            int numCandidates = servers.length;
            boolean[] results = new boolean[numCandidates];
            if (logger.isDebugEnabled()) {
                logger.debug("LoadBalancer:  PingTask executing [" + numCandidates + "] servers configured");
            }
            if (ping == null) {
                logger.error("IPing is null, will mark all servers as not alive");
                return results;
            }
            ArrayList<Callable<Boolean>> callables = new ArrayList<Callable<Boolean>>();
            for (Server server : servers) {
                callables.add(() -> ping.isAlive(server));
            }
            if (this.executor.isTerminated()) {
                return results;
            }
            try {
                List ret = ConcurrentUtils.submitTasksBlocking((Executor)this.executor, callables);
                int i = 0;
                for (Boolean b : ret) {
                    results[i++] = b;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return results;
        }

        public void destroy() throws Exception {
            this.executor.shutdown();
        }
    }
}

