/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.loadbalancer;

import cn.com.duiba.boot.netflix.ribbon.RibbonServerListFilter;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.loadbalancer.FilterBasedRule;
import com.netflix.loadbalancer.AbstractLoadBalancer;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.LoadBalancerStats;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerStats;
import java.util.List;

public class WeightedLeastConnectionRule
extends FilterBasedRule {
    public WeightedLeastConnectionRule(ILoadBalancer lb, List<RibbonServerListFilter> serverListFilters) {
        super(serverListFilters);
        this.setLoadBalancer(lb);
    }

    @Override
    protected Server chooseFromServers(List<Server> servers, ILoadBalancer lb, Object key) {
        int n = servers.size();
        if (n == 0) {
            return null;
        }
        int[] weight = new int[servers.size()];
        int[] activeRequestCount = new int[servers.size()];
        AbstractLoadBalancer nlb = (AbstractLoadBalancer)lb;
        LoadBalancerStats stats = nlb.getLoadBalancerStats();
        for (int i = 0; i < weight.length; ++i) {
            Server s = servers.get(i);
            weight[i] = this.getTimeBasedWeight(s);
            ServerStats stat = stats.getSingleServerStat(s);
            activeRequestCount[i] = stat.getActiveRequestsCount();
        }
        for (int m = 0; m < n; ++m) {
            if (weight[m] <= 0) continue;
            int choosedIndex = m;
            for (int i = m + 1; i < n; ++i) {
                if (activeRequestCount[choosedIndex] * weight[i] <= activeRequestCount[i] * weight[choosedIndex]) continue;
                choosedIndex = i;
            }
            return servers.get(choosedIndex);
        }
        return null;
    }
}

