/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.zipkin;

import brave.Tracer;
import brave.sampler.Sampler;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.turbo.TurboFilter;
import cn.com.duibaboot.ext.autoconfigure.cloud.zipkin.DuibaRpcParamsInterceptor;
import cn.com.duibaboot.ext.autoconfigure.cloud.zipkin.DuibaTraceFilter;
import cn.com.duibaboot.ext.autoconfigure.cloud.zipkin.DuibaTraceSecondFilter;
import cn.com.duibaboot.ext.autoconfigure.cloud.zipkin.PercentageBasedSampler;
import cn.com.duibaboot.ext.autoconfigure.cloud.zipkin.ZipkinLoadBalancerBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.cloud.zipkin.ZipkinLogTurboFilter;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import javax.servlet.Filter;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.cloud.sleuth.instrument.web.TraceWebFilter;
import org.springframework.cloud.sleuth.sampler.SamplerProperties;
import org.springframework.cloud.sleuth.zipkin2.ZipkinAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import zipkin2.Span;

@Configuration
@ConditionalOnClass(value={Span.class, ZipkinAutoConfiguration.class})
@EnableConfigurationProperties(value={SamplerProperties.class})
@AutoConfigureBefore(value={ZipkinAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.zipkin.enabled"}, matchIfMissing=true)
public class DuibaZipkinAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"duiba.zipkin.port"}, matchIfMissing=false)
    public static SpecifiedBeanPostProcessor zipkinLoadBalancerBeanPostProcessor(@Value(value="${duiba.zipkin.port}") int zipkinPort) {
        return new ZipkinLoadBalancerBeanPostProcessor(zipkinPort);
    }

    static class ZipkinWebMvcConfigurer
    implements WebMvcConfigurer {
        @Autowired
        private DuibaRpcParamsInterceptor duibaRpcParamsInterceptor;

        ZipkinWebMvcConfigurer() {
        }

        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor((HandlerInterceptor)this.duibaRpcParamsInterceptor).addPathPatterns(new String[]{"/**"});
        }
    }

    @Configuration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnClass(value={TraceWebFilter.class, Tracer.class})
    static class ZipkinFiltersConfiguration {
        ZipkinFiltersConfiguration() {
        }

        @Bean
        public Filter duibaTraceFilter() {
            LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
            context.addTurboFilter((TurboFilter)new ZipkinLogTurboFilter());
            return new DuibaTraceFilter();
        }

        @Bean
        public Filter duibaTracSecondFilter() {
            return new DuibaTraceSecondFilter();
        }

        @Bean
        public DuibaRpcParamsInterceptor duibaRpcParamsInterceptor() {
            return new DuibaRpcParamsInterceptor();
        }

        @Bean
        public ZipkinWebMvcConfigurer zipkinWebMvcConfigurer() {
            return new ZipkinWebMvcConfigurer();
        }
    }

    @Configuration
    @ConditionalOnMissingClass(value={"org.springframework.cloud.context.config.annotation.RefreshScope"})
    protected static class NonRefreshScopePercentageBasedSamplerConfiguration {
        protected NonRefreshScopePercentageBasedSamplerConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public Sampler defaultTraceSampler(SamplerProperties config) {
            return new PercentageBasedSampler(config);
        }
    }

    @Configuration
    @ConditionalOnClass(value={RefreshScope.class})
    protected static class RefreshScopedPercentageBasedSamplerConfiguration {
        protected RefreshScopedPercentageBasedSamplerConfiguration() {
        }

        @Bean
        @RefreshScope
        @ConditionalOnMissingBean
        public Sampler defaultTraceSampler(SamplerProperties config) {
            return new PercentageBasedSampler(config);
        }
    }
}

