/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.data.redis;

import cn.com.duibaboot.ext.autoconfigure.data.redis.JedisConnectionConfiguration;
import cn.com.duibaboot.ext.autoconfigure.data.redis.RedisProperties;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.data.redis.JedisClientConfigurationBuilderCustomizer;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;

public class JedisConnectionFactoryBean
implements FactoryBean<JedisConnectionFactory> {
    @Resource
    private RedisProperties redisProperties;
    @Resource
    ObjectProvider<RedisSentinelConfiguration> sentinelConfiguration;
    @Resource
    ObjectProvider<RedisClusterConfiguration> clusterConfiguration;
    @Resource
    ObjectProvider<List<JedisClientConfigurationBuilderCustomizer>> builderCustomizers;
    private String extraRedisTemplateIdPrefix;

    public JedisConnectionFactoryBean(String extraRedisTemplateIdPrefix) {
        this.extraRedisTemplateIdPrefix = extraRedisTemplateIdPrefix;
    }

    private RedisProperties getRedisProperties() {
        if (this.extraRedisTemplateIdPrefix == null) {
            return this.redisProperties;
        }
        return this.redisProperties.getExtra().get(this.extraRedisTemplateIdPrefix);
    }

    public JedisConnectionFactory getObject() throws Exception {
        JedisConnectionConfiguration fc = new JedisConnectionConfiguration(this.getRedisProperties(), this.sentinelConfiguration, this.clusterConfiguration, this.builderCustomizers);
        JedisConnectionFactory f = fc.redisConnectionFactory();
        f.afterPropertiesSet();
        return f;
    }

    public Class<?> getObjectType() {
        return JedisConnectionFactory.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

