/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.datasource;

import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestRoutingDataSource;
import com.alibaba.fastjson.JSON;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.HikariPoolMXBean;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;

public class DuibaDataSourceMonitor
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(DuibaDataSourceMonitor.class);
    private static final boolean HIKARI_CLASS_EXISTS;
    private static final boolean HIKARI_MONITOR_EXISTS;
    private static final boolean DBCP2_CLASS_EXISTS;
    private boolean initted = false;
    private Map<String, DataSource> dataSourceMap;
    private Thread duibaDataSourceMonitorThread;
    private static final long RETENTION_TIME = 1800000L;
    private Map<String, Map<Long, MonitorObj>> secondMonitorMap = new ConcurrentHashMap<String, Map<Long, MonitorObj>>();

    protected synchronized String getSecondMonitorJson() {
        return JSON.toJSONString(this.secondMonitorMap);
    }

    public synchronized void startMonitorThread(ApplicationContext context) {
        if (!this.initted) {
            this.initted = true;
            this.dataSourceMap = context.getBeansOfType(DataSource.class);
            if (this.dataSourceMap.isEmpty()) {
                return;
            }
            this.duibaDataSourceMonitorThread = new Thread(() -> this.scanDataSources(), "duibaDataSourceMonitorThread");
            this.duibaDataSourceMonitorThread.start();
        }
    }

    private void scanDataSources() {
        while (true) {
            try {
                do {
                    for (Map.Entry<String, DataSource> entry : this.dataSourceMap.entrySet()) {
                        DataSource ds = entry.getValue();
                        if (ds instanceof PerfTestRoutingDataSource) {
                            PerfTestRoutingDataSource pds = (PerfTestRoutingDataSource)((Object)ds);
                            this.scanDataSource(entry.getKey(), pds.getOriginalDataSource());
                            this.scanDataSource(entry.getKey() + "_shade", pds.getShadeDataSource());
                            continue;
                        }
                        this.scanDataSource(entry.getKey(), ds);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                } while (!Thread.currentThread().isInterrupted());
            }
            catch (Throwable e) {
                log.warn(e.getMessage(), e);
                continue;
            }
            break;
        }
    }

    private synchronized void scanDataSource(String key, DataSource ds) {
        if (this.isValid(ds)) {
            MonitorObj currentMonitorObj = this.getCurrentMonitorObj(ds);
            if (currentMonitorObj == null) {
                return;
            }
            this.warnIfTooFull(key, currentMonitorObj);
            Map dbSecondMonitorMap = this.secondMonitorMap.computeIfAbsent(key, s -> new LinkedHashMap<Long, MonitorObj>(){

                @Override
                protected boolean removeEldestEntry(Map.Entry<Long, MonitorObj> eldest) {
                    return eldest.getKey() < System.currentTimeMillis() - 1800000L;
                }
            });
            dbSecondMonitorMap.put(System.currentTimeMillis(), currentMonitorObj);
        }
    }

    private void warnIfTooFull(String key, MonitorObj currentMonitorObj) {
        int numIdleConnections = currentMonitorObj.getNumAllocated() - currentMonitorObj.getNumActive();
        if (currentMonitorObj.getNumActive() >= 3 && currentMonitorObj.getNumAllocated() >= currentMonitorObj.getMaxTotal() - 3 && currentMonitorObj.getNumActive() >= currentMonitorObj.getNumAllocated() - 3) {
            log.error("datasource [" + key + "]'s connectionPool is too full,max:" + currentMonitorObj.getMaxTotal() + ",busy:" + currentMonitorObj.getNumActive() + ",idle:" + numIdleConnections);
        }
    }

    private MonitorObj getCurrentMonitorObj(DataSource ds) {
        if (DBCP2_CLASS_EXISTS && ds instanceof BasicDataSource) {
            BasicDataSource ds1 = (BasicDataSource)ds;
            int numIdleConnections = ds1.getNumIdle();
            int numActiveConnections = ds1.getNumActive();
            int maxTotal = ds1.getMaxTotal();
            return new MonitorObj(numIdleConnections, numActiveConnections, maxTotal, -1);
        }
        if (HIKARI_CLASS_EXISTS && ds instanceof HikariDataSource) {
            if (HIKARI_MONITOR_EXISTS) {
                HikariDataSource ds1 = (HikariDataSource)ds;
                HikariPoolMXBean poolMXBean = ds1.getHikariPoolMXBean();
                if (poolMXBean == null) {
                    return null;
                }
                int numIdleConnections = poolMXBean.getIdleConnections();
                int numActiveConnections = poolMXBean.getActiveConnections();
                int maxTotal = ((HikariDataSource)ds).getMaximumPoolSize();
                int threadsAwaitingConnection = poolMXBean.getThreadsAwaitingConnection();
                return new MonitorObj(numIdleConnections, numActiveConnections, maxTotal, threadsAwaitingConnection);
            }
            return null;
        }
        throw new IllegalStateException("[notifyme]will not be here");
    }

    private boolean isValid(DataSource ds) {
        if (ds != null) {
            if (DBCP2_CLASS_EXISTS && ds instanceof BasicDataSource && !((BasicDataSource)ds).isClosed()) {
                return true;
            }
            if (HIKARI_CLASS_EXISTS && ds instanceof HikariDataSource && !((HikariDataSource)ds).isClosed()) {
                return true;
            }
        }
        return false;
    }

    public List<DataSourceConfig> getDataSourceConfig() {
        ArrayList<DataSourceConfig> dataSourceConfigs = new ArrayList<DataSourceConfig>();
        for (Map.Entry<String, DataSource> entry : this.dataSourceMap.entrySet()) {
            DataSource ds = entry.getValue();
            if (ds instanceof PerfTestRoutingDataSource) {
                PerfTestRoutingDataSource pds = (PerfTestRoutingDataSource)((Object)ds);
                this.scanDataSourceForConfig(entry.getKey(), pds.getOriginalDataSource(), dataSourceConfigs);
                this.scanDataSourceForConfig(entry.getKey() + "_shade", pds.getShadeDataSource(), dataSourceConfigs);
                continue;
            }
            this.scanDataSourceForConfig(entry.getKey(), ds, dataSourceConfigs);
        }
        return dataSourceConfigs;
    }

    private synchronized void scanDataSourceForConfig(String key, DataSource ds, List<DataSourceConfig> dataSourceConfigs) {
        DataSourceConfig dataSourceConfig;
        if (this.isValid(ds) && (dataSourceConfig = this.getDataSourceConfig(key, ds)) != null) {
            dataSourceConfigs.add(dataSourceConfig);
        }
    }

    private DataSourceConfig getDataSourceConfig(String key, DataSource ds) {
        if (DBCP2_CLASS_EXISTS && ds instanceof BasicDataSource) {
            BasicDataSource ds1 = (BasicDataSource)ds;
            return new DataSourceConfig(key, ds1.getUrl(), ds1.getUsername(), ds1.getMaxTotal(), ds1.getInitialSize(), ds1.getMaxIdle(), ds1.getMinIdle(), ds1.getMaxWaitMillis());
        }
        if (HIKARI_CLASS_EXISTS && ds instanceof HikariDataSource) {
            if (HIKARI_MONITOR_EXISTS) {
                HikariDataSource ds1 = (HikariDataSource)ds;
                return new DataSourceConfig(key, ds1.getJdbcUrl(), ds1.getUsername(), ds1.getMaximumPoolSize(), -1, -1, ds1.getMinimumIdle(), ds1.getConnectionTimeout());
            }
            return null;
        }
        throw new IllegalStateException("[notifyme]will not be here");
    }

    public synchronized void destroy() throws Exception {
        if (this.duibaDataSourceMonitorThread != null) {
            this.duibaDataSourceMonitorThread.interrupt();
        }
    }

    static {
        boolean hikariClassExists = false;
        boolean hikariMonitorExists = false;
        boolean dbcp2ClassExists = false;
        try {
            Class.forName("com.zaxxer.hikari.HikariDataSource");
            hikariClassExists = true;
            HikariDataSource.class.getDeclaredMethod("getHikariPoolMXBean", new Class[0]);
            hikariMonitorExists = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException e) {
            log.warn("\u8bf7\u628ahikari\u5347\u7ea7\u5230\u6700\u65b0\u7248\uff0c\u5426\u5219\u65e0\u6cd5\u76d1\u63a7\u8fde\u63a5\u6c60\u4f7f\u7528\u6570\u636e");
        }
        HIKARI_MONITOR_EXISTS = hikariMonitorExists;
        try {
            Class.forName("org.apache.commons.dbcp2.BasicDataSource");
            dbcp2ClassExists = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        HIKARI_CLASS_EXISTS = hikariClassExists;
        DBCP2_CLASS_EXISTS = dbcp2ClassExists;
    }

    public static class MonitorObj {
        private short numActive;
        private short numAllocated;
        private short maxTotal;
        private short threadsAwaitingConnection;

        public MonitorObj(int numIdleConnections, int numActiveConnections, int maxTotal, int threadsAwaitingConnection) {
            this.numActive = (short)numActiveConnections;
            this.maxTotal = (short)maxTotal;
            this.numAllocated = (short)(numActiveConnections + numIdleConnections);
            this.threadsAwaitingConnection = (short)threadsAwaitingConnection;
        }

        public MonitorObj() {
        }

        public short getNumActive() {
            return this.numActive;
        }

        public short getNumAllocated() {
            return this.numAllocated;
        }

        public short getMaxTotal() {
            return this.maxTotal;
        }

        public short getThreadsAwaitingConnection() {
            return this.threadsAwaitingConnection;
        }
    }

    public static class DataSourceConfig {
        private String dataSourceName;
        private String url;
        private String username;
        private int maxTotal;
        private int initialSize;
        private int maxIdle;
        private int minIdle;
        private long maxWaitMillis;

        public String getDataSourceName() {
            return this.dataSourceName;
        }

        public String getUrl() {
            return this.url;
        }

        public String getUsername() {
            return this.username;
        }

        public int getMaxTotal() {
            return this.maxTotal;
        }

        public int getInitialSize() {
            return this.initialSize;
        }

        public int getMaxIdle() {
            return this.maxIdle;
        }

        public int getMinIdle() {
            return this.minIdle;
        }

        public long getMaxWaitMillis() {
            return this.maxWaitMillis;
        }

        public void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setMaxTotal(int maxTotal) {
            this.maxTotal = maxTotal;
        }

        public void setInitialSize(int initialSize) {
            this.initialSize = initialSize;
        }

        public void setMaxIdle(int maxIdle) {
            this.maxIdle = maxIdle;
        }

        public void setMinIdle(int minIdle) {
            this.minIdle = minIdle;
        }

        public void setMaxWaitMillis(long maxWaitMillis) {
            this.maxWaitMillis = maxWaitMillis;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataSourceConfig)) {
                return false;
            }
            DataSourceConfig other = (DataSourceConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$dataSourceName = this.getDataSourceName();
            String other$dataSourceName = other.getDataSourceName();
            if (this$dataSourceName == null ? other$dataSourceName != null : !this$dataSourceName.equals(other$dataSourceName)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            if (this.getMaxTotal() != other.getMaxTotal()) {
                return false;
            }
            if (this.getInitialSize() != other.getInitialSize()) {
                return false;
            }
            if (this.getMaxIdle() != other.getMaxIdle()) {
                return false;
            }
            if (this.getMinIdle() != other.getMinIdle()) {
                return false;
            }
            return this.getMaxWaitMillis() == other.getMaxWaitMillis();
        }

        protected boolean canEqual(Object other) {
            return other instanceof DataSourceConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $dataSourceName = this.getDataSourceName();
            result = result * 59 + ($dataSourceName == null ? 43 : $dataSourceName.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            result = result * 59 + this.getMaxTotal();
            result = result * 59 + this.getInitialSize();
            result = result * 59 + this.getMaxIdle();
            result = result * 59 + this.getMinIdle();
            long $maxWaitMillis = this.getMaxWaitMillis();
            result = result * 59 + (int)($maxWaitMillis >>> 32 ^ $maxWaitMillis);
            return result;
        }

        public String toString() {
            return "DuibaDataSourceMonitor.DataSourceConfig(dataSourceName=" + this.getDataSourceName() + ", url=" + this.getUrl() + ", username=" + this.getUsername() + ", maxTotal=" + this.getMaxTotal() + ", initialSize=" + this.getInitialSize() + ", maxIdle=" + this.getMaxIdle() + ", minIdle=" + this.getMinIdle() + ", maxWaitMillis=" + this.getMaxWaitMillis() + ")";
        }

        public DataSourceConfig() {
        }

        public DataSourceConfig(String dataSourceName, String url, String username, int maxTotal, int initialSize, int maxIdle, int minIdle, long maxWaitMillis) {
            this.dataSourceName = dataSourceName;
            this.url = url;
            this.username = username;
            this.maxTotal = maxTotal;
            this.initialSize = initialSize;
            this.maxIdle = maxIdle;
            this.minIdle = minIdle;
            this.maxWaitMillis = maxWaitMillis;
        }
    }
}

