/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.monitor.cache;

import cn.com.duibaboot.ext.autoconfigure.monitor.cache.CacheChangeRecord;
import cn.com.duibaboot.ext.autoconfigure.monitor.cache.CacheMonitorManager;
import cn.com.duibaboot.ext.autoconfigure.monitor.cache.RecordPagerResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpoint;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerEndpoint(id="monitor-cache")
public class CacheMonitorMvcEndpoint {
    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"}, value={"/{path}"})
    public Object invoke(@PathVariable String path, @RequestParam(value="key", required=false) String key, @RequestParam(value="cacheName", required=false) String cacheName, @RequestParam(value="page", required=false) String page) {
        if (path.equals("all")) {
            return CacheMonitorManager.getAllCache();
        }
        if (path.equals("query")) {
            return this.doQuery(key, cacheName);
        }
        if (path.equals("record")) {
            return this.doRecord(key, cacheName, page);
        }
        if (path.equals("clearAll")) {
            CacheMonitorManager.clearAllCacheValue();
            return Boolean.TRUE;
        }
        return "";
    }

    private Object doQuery(String key, String cacheName) {
        if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)cacheName)) {
            return "";
        }
        return CacheMonitorManager.getCacheValueByKey(cacheName, key);
    }

    private Object doRecord(String key, String cacheName, String page) {
        RecordPagerResponse<CacheChangeRecord> records;
        if (StringUtils.isBlank((CharSequence)page)) {
            page = "1";
        }
        if ((records = CacheMonitorManager.getRecord(cacheName, key, Integer.parseInt(page))) == null) {
            return "";
        }
        return records;
    }
}

