package cn.com.duibaboot.ext.autoconfigure.ons;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.cat.annotation.CatTransaction;
import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;

/**
 * OnsMessageListener的包装，增加cat监控
 */
public class OnsMessageListenerWrapper implements MessageListener {

    private MessageListener source;

    public OnsMessageListenerWrapper(MessageListener source){
        this.source = source;
    }

    @Override
    @CatTransaction(type="MessageQueue", name="ons.consume")
    public Action consume(Message message, ConsumeContext context) {
        DBTimeProfile.start();
        try {
            return source.consume(message, context);
        }finally {
            DBTimeProfile.end("ons.consume");
        }
    }
}
