package cn.com.duibaboot.ext.autoconfigure.perftest;

import cn.com.duiba.boot.perftest.InternalPerfTestContext;
import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duiba.boot.perftest.PerfTestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.consumer.listener.*;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageExt;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 加入AOP，压测时rocketmq消息添加压测标识
 */
@Aspect
public class RocketMqPerfAspect {
    //如果perfTestFootMarker为null，表示没有引入spring-boot-starter-perftest压测包
    @Autowired(required = false)
    private PerfTestFootMarker perfTestFootMarker;

    private static final String PERF_TEST_PROPERTY = "perfTest";

    private static final Logger logger = LoggerFactory.getLogger(RocketMqPerfAspect.class);

    @Around("execution(* org.apache.rocketmq.client.producer.DefaultMQProducer+.*(..))")
    public Object rocketMqProducerJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        if (signature.getMethod().getName().startsWith("send")
            && signature.getParameterTypes().length >= 1
            && signature.getParameterTypes()[0].equals(Message.class)
            && InternalPerfTestContext.isCurrentInPerfTestMode()){
            PerfTestContext.debugInfo("rocketMQProducer");

            Object[] args = joinPoint.getArgs();
            Message m = (Message)args[0];
            if(m != null){
                m.putUserProperty(PERF_TEST_PROPERTY, "true");
                String sceneId = InternalPerfTestContext.getCurrentSceneId();
                if (StringUtils.isNotBlank(sceneId)) {
                    m.putUserProperty(PerfTestUtils.PERF_TEST_SCENE_ID_KEY, sceneId);
                }
            }
            return joinPoint.proceed(args);
        }
        return joinPoint.proceed();
    }

    @Around("execution(* org.apache.rocketmq.client.consumer.listener.MessageListener+.*(..))")
    public Object rocketMqConsumerJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable { //NOSONAR
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        if (signature.getMethod().getName().startsWith("consumeMessage")
                && signature.getParameterTypes().length >= 1
                && signature.getParameterTypes()[0].equals(List.class)){
            Object[] args = joinPoint.getArgs();
            List<MessageExt> list = (List<MessageExt>)args[0];
            if(list != null && list.size() == 1){
                MessageExt m = list.get(0);
                if("true".equals(m.getUserProperty(PERF_TEST_PROPERTY))){
                    //perfTestFootMarker为null表示当前项目没有接入压测
                    // 如果没有接入压测则不应该消费压测消息，直接返回消费成功，丢弃该消息
                    if(perfTestFootMarker == null){
                        MessageListener listener = (MessageListener)joinPoint.getTarget();
                        if(listener instanceof MessageListenerConcurrently) {
                            return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
                        }else if(listener instanceof MessageListenerOrderly){
                            return ConsumeOrderlyStatus.SUCCESS;
                        }else{
                            logger.error("[NOTIFYME]尚未支持的rocketmq messageListener");
                        }
                    }

                    InternalPerfTestContext.markAsPerfTest(m.getUserProperty(PerfTestUtils.PERF_TEST_SCENE_ID_KEY));
                    perfTestFootMarker.markApp();
                    PerfTestContext.debugInfo("rocketMQConsumer");
                    try {
                        return joinPoint.proceed();
                    }finally {
                        InternalPerfTestContext.markAsNormal();
                    }
                }
            }else if(list != null && list.size() > 1){
                List<MessageExt> newList = new ArrayList<>();
                for(MessageExt m : list){
                    if(!"true".equals(m.getUserProperty(PERF_TEST_PROPERTY))){
                        newList.add(m);
                    }
                }
                if(newList.size() != list.size()) {
                    logger.warn("检测到rocketmq消费者中一次消费了多条消息且消息中有压测消息，将丢弃其中的压测消息（如需支持压测请设置DefaultMQPushConsumer.setConsumeMessageBatchMaxSize 为1）");
                    args[0] = newList;
                    return joinPoint.proceed(args);
                }
            }
        }
        return joinPoint.proceed();
    }

}
