/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cat;

import brave.ErrorParser;
import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import zipkin2.Endpoint;

@Aspect
@Order(value=-1)
public class SleuthSpringDataRedisPlugin {
    private static final Logger logger = LoggerFactory.getLogger(SleuthSpringDataRedisPlugin.class);
    @Autowired
    private Tracer tracer;
    @Autowired
    private ErrorParser errorParser;
    private volatile Class<?> lastJedisConnectionProxyClass;

    @Around(value="execution(* org.springframework.data.redis.connection.jedis.JedisConnectionFactory.getConnection(..))")
    public Object springDataRedisJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        Span curSpan = this.tracer.currentSpan();
        if (curSpan == null || curSpan.isNoop()) {
            return joinPoint.proceed();
        }
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        if ("getConnection".equals(methodName)) {
            try {
                JedisConnection connection = (JedisConnection)joinPoint.proceed();
                ProxyFactory factory = new ProxyFactory();
                factory.setTarget((Object)connection);
                factory.addAdvice((Advice)new JedisConnectionMethodInterceptor());
                JedisConnection newConnection = (JedisConnection)factory.getProxy();
                if (this.lastJedisConnectionProxyClass != null && this.lastJedisConnectionProxyClass != newConnection.getClass()) {
                    logger.error("JedisConnectionProxyClass is not same\uff0cthis is spring's bug,please upgrade spring-boot's version to 1.3.8.RELEASE or higher! {},{},{},{}", new Object[]{this.getClass().getClassLoader(), newConnection.getClass().getClassLoader(), this.lastJedisConnectionProxyClass, newConnection.getClass()});
                }
                this.lastJedisConnectionProxyClass = newConnection.getClass();
                return newConnection;
            }
            catch (Throwable e) {
                Span span = this.tracer.nextSpan().name("redis:/" + methodName).kind(Span.Kind.CLIENT).remoteEndpoint(Endpoint.newBuilder().serviceName("redis").build()).start();
                span.tag("redis.op", methodName);
                span.tag("lc", "springDataRedis");
                this.errorParser.error(e, (SpanCustomizer)span);
                span.finish();
                throw e;
            }
        }
        return joinPoint.proceed();
    }

    private Object interceptorRedisMethods(MethodInvocation invocation) throws Throwable {
        String methodName = invocation.getMethod().getName();
        if (methodName.equals("toString") || methodName.equals("hashCode") || methodName.equals("equals")) {
            return invocation.proceed();
        }
        Span span = this.tracer.nextSpan().name("redis:/" + methodName).kind(Span.Kind.CLIENT).remoteEndpoint(Endpoint.newBuilder().serviceName("redis").build()).start();
        try {
            Object obj;
            span.tag("redis.op", methodName);
            span.tag("lc", "springDataRedis");
            if ("get".equals(methodName) && invocation.getArguments() != null && invocation.getArguments().length == 1 && invocation.getArguments()[0] != null) {
                obj = invocation.getArguments()[0];
                if (obj instanceof byte[]) {
                    span.tag("redis.key", new String((byte[])obj));
                } else {
                    span.tag("redis.key", obj.toString());
                }
            }
            obj = invocation.proceed();
            return obj;
        }
        catch (Exception e) {
            this.errorParser.error((Throwable)e, (SpanCustomizer)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    private class JedisMethodInterceptor
    implements MethodInterceptor {
        JedisMethodInterceptor() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            return SleuthSpringDataRedisPlugin.this.interceptorRedisMethods(invocation);
        }
    }

    private class JedisConnectionMethodInterceptor
    implements MethodInterceptor {
        JedisConnectionMethodInterceptor() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            String methodName = invocation.getMethod().getName();
            if (methodName.equals("isPipelined") || methodName.equals("openPipeline") || methodName.equals("isQueueing") || methodName.equals("isClosed") || methodName.equals("close") || methodName.equals("closePipeline") || methodName.endsWith("Commands")) {
                return invocation.proceed();
            }
            if (methodName.equals("getNativeConnection")) {
                Object nativeConnection = invocation.proceed();
                ProxyFactory factory = new ProxyFactory();
                factory.setTarget(nativeConnection);
                factory.addAdvice((Advice)new JedisMethodInterceptor());
                Object newNativeConnection = factory.getProxy();
                return newNativeConnection;
            }
            return SleuthSpringDataRedisPlugin.this.interceptorRedisMethods(invocation);
        }
    }
}

