/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign;

import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.DuibaFeignProperties;
import cn.com.duibaboot.ext.autoconfigure.core.rpc.RpcContext;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Collection;

public class CustomRequestInterceptor
implements RequestInterceptor {
    public static final String X_RPC = "X-Rpc";
    public static final String X_SERIAL = "X-SERIAL";
    private DuibaFeignProperties duibaFeignProperties;

    public CustomRequestInterceptor(DuibaFeignProperties duibaFeignProperties) {
        this.duibaFeignProperties = duibaFeignProperties;
    }

    public void apply(RequestTemplate template) {
        this.appendArgs(template);
        template.header(X_RPC, new String[]{"true"});
        String catRootId = RpcContext.getContext().getAttachment("_catRootMessageId");
        String catChildId = RpcContext.getContext().getAttachment("_catChildMessageId");
        String catParentId = RpcContext.getContext().getAttachment("_catParentMessageId");
        String rpcClient = RpcContext.getContext().getAttachment("X-Rpc-Client");
        if (catRootId != null) {
            template.header("_catRootMessageId", new String[]{catRootId});
        }
        if (catChildId != null) {
            template.header("_catChildMessageId", new String[]{catChildId});
        }
        if (catParentId != null) {
            template.header("_catParentMessageId", new String[]{catParentId});
        }
        if (rpcClient != null) {
            template.header("X-Rpc-Client", new String[]{rpcClient});
        }
    }

    private void appendArgs(RequestTemplate template) {
        Collection coll = (Collection)template.headers().get(X_SERIAL);
        if (coll != null && coll.size() == 1 && DuibaFeignProperties.DuibaFeignSerialization.typeOf((String)coll.iterator().next()) != DuibaFeignProperties.DuibaFeignSerialization.JSON) {
            byte[] bs;
            Object[] args = RpcContext.getContext().getInvokeArgs();
            if (this.duibaFeignProperties.getSerializationEnum() != DuibaFeignProperties.DuibaFeignSerialization.JSON && (bs = this.duibaFeignProperties.getSerializationEnum().serialize(args)) != null) {
                template.body(bs, null);
            }
        }
    }
}

