/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.hystrix;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesFactory;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="circuit-breaker")
public class CircuitBreakerEndpoint {
    private final Map<String, Object> circuitBreakerInfo;

    public CircuitBreakerEndpoint(Map<String, Object> circuitBreakerInfo) {
        this.circuitBreakerInfo = circuitBreakerInfo;
    }

    @ReadOperation
    public String invoke() {
        HashMap circuitBreakerMap = Maps.newHashMap(this.circuitBreakerInfo);
        this.refreshProperty(circuitBreakerMap, 0);
        return JSON.toJSONString((Object)circuitBreakerMap);
    }

    private void refreshProperty(Map<String, Object> circuitBreakerMap, int i) {
        for (Map.Entry<String, Object> kv : circuitBreakerMap.entrySet()) {
            if (i == 2) {
                if (kv.getKey().equals("coreSize") || kv.getKey().equals("maximumSize") || kv.getKey().equals("maxQueueSize")) continue;
                HystrixCommandProperties commandProperties = HystrixPropertiesFactory.getCommandProperties((HystrixCommandKey)HystrixCommandKey.Factory.asKey((String)kv.getKey()), null);
                HashMap commandProperty = Maps.newHashMap();
                commandProperty.put("execution.isolation.thread.timeoutInMilliseconds", commandProperties.executionTimeoutInMilliseconds().get());
                commandProperty.put("circuitBreaker.forceOpen", commandProperties.circuitBreakerForceOpen().get());
                kv.setValue(commandProperty);
                continue;
            }
            Map val = (Map)kv.getValue();
            if (i == 1) {
                HystrixThreadPoolProperties threadProperties = HystrixPropertiesFactory.getThreadPoolProperties((HystrixThreadPoolKey)HystrixThreadPoolKey.Factory.asKey((String)kv.getKey()), null);
                val.put("coreSize", threadProperties.coreSize().get());
                val.put("maximumSize", threadProperties.maximumSize().get());
                val.put("maxQueueSize", threadProperties.maxQueueSize().get());
            }
            int next = i + 1;
            this.refreshProperty(val, next);
        }
    }
}

