/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon;

import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.CustomRibbonServerList;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.RibbonCustomAutoConfiguration;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.RibbonPing;
import com.netflix.client.IClientConfigAware;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.IPingStrategy;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.ServerList;
import java.lang.reflect.Constructor;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.netflix.ribbon.PropertiesFactory;
import org.springframework.cloud.netflix.ribbon.RibbonAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@AutoConfigureBefore(value={RibbonAutoConfiguration.class})
@ConditionalOnClass(value={IPing.class, IRule.class, ILoadBalancer.class, IPingStrategy.class})
public class RibbonPropertiesFactoryAutoConfiguration {
    @Bean
    public PropertiesFactory propertiesFactory() {
        return new CustomPropertiesFactory();
    }

    private static class CustomPropertiesFactory
    extends PropertiesFactory {
        @Resource
        ApplicationContext context;

        private CustomPropertiesFactory() {
        }

        public String getClassName(Class clazz, String name) {
            if (clazz.equals(IRule.class)) {
                return RibbonCustomAutoConfiguration.CustomZoneAvoidanceRule.class.getName();
            }
            if (clazz.equals(IPing.class)) {
                return RibbonPing.class.getName();
            }
            if (clazz.equals(ServerList.class)) {
                return CustomRibbonServerList.class.getName();
            }
            return super.getClassName(clazz, name);
        }

        public <C> C get(Class<C> clazz, IClientConfig config, String name) {
            if (!ServerList.class.equals(clazz) && !IRule.class.equals(clazz)) {
                return (C)super.get(clazz, config, name);
            }
            String className = this.getClassName(clazz, name);
            if (StringUtils.hasText((String)className)) {
                try {
                    Class<?> toInstantiate = Class.forName(className);
                    return (C)this.instantiateWithConfig(this.context, toInstantiate, config);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Unknown class to load " + className + " for class " + clazz + " named " + name);
                }
            }
            return null;
        }

        <C> C instantiateWithConfig(ApplicationContext context, Class<C> clazz, IClientConfig config) {
            Object result = null;
            try {
                Constructor<C> constructor = clazz.getConstructor(IClientConfig.class);
                result = constructor.newInstance(config);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (result == null) {
                result = BeanUtils.instantiate(clazz);
                if (result instanceof IClientConfigAware) {
                    ((IClientConfigAware)result).initWithNiwsConfig(config);
                }
                if (context != null) {
                    context.getAutowireCapableBeanFactory().autowireBean(result);
                }
            }
            return (C)result;
        }
    }
}

