/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest;

import cn.com.duiba.boot.perftest.InternalPerfTestContext;
import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestFootMarker;
import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.Message;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Aspect
public class OnsPerfAspect {
    @Autowired(required=false)
    private PerfTestFootMarker perfTestFootMarker;
    private static final Logger logger = LoggerFactory.getLogger(OnsPerfAspect.class);

    @Around(value="execution(* com.aliyun.openservices.ons.api.Producer+.*(..))")
    public Object onsSendJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        if (InternalPerfTestContext.isCurrentInPerfTestMode()) {
            PerfTestContext.debugInfo((String)"onsProducer");
            Object[] args = joinPoint.getArgs();
            if (methodName.startsWith("send") && args[0] instanceof Message) {
                Message rawMsg = (Message)args[0];
                rawMsg.putUserProperties("perfTest", "true");
                String sceneId = InternalPerfTestContext.getCurrentSceneId();
                if (StringUtils.isNotBlank((CharSequence)sceneId)) {
                    rawMsg.putUserProperties("_duibaPerfSceneId", sceneId);
                }
                return joinPoint.proceed(args);
            }
        }
        return joinPoint.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(* com.aliyun.openservices.ons.api.MessageListener+.*(..))")
    public Object onsConsumeJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        Message rawMsg;
        Object[] args;
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        if (methodName.equals("consume") && (args = joinPoint.getArgs())[0] instanceof Message && "true".equals((rawMsg = (Message)args[0]).getUserProperties("perfTest"))) {
            if (this.perfTestFootMarker == null) {
                return Action.CommitMessage;
            }
            String perfTestSceneId = rawMsg.getUserProperties("_duibaPerfSceneId");
            InternalPerfTestContext.markAsPerfTest((String)perfTestSceneId);
            this.perfTestFootMarker.markApp();
            PerfTestContext.debugInfo((String)"onsConsumer");
            try {
                Object object = joinPoint.proceed();
                return object;
            }
            finally {
                InternalPerfTestContext.markAsNormal();
            }
        }
        return joinPoint.proceed();
    }
}

