package cn.com.duibaboot.ext.autoconfigure.cloud.zipkin;

import brave.sampler.Sampler;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.cloud.sleuth.sampler.SamplerProperties;
import org.springframework.cloud.sleuth.zipkin2.ZipkinAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 设置采样器（最低支持万分之一的采样率）
 * @author liuyao
 */
@Configuration
@ConditionalOnClass({zipkin2.Span.class, ZipkinAutoConfiguration.class})
@EnableConfigurationProperties({SamplerProperties.class})
@AutoConfigureBefore(ZipkinAutoConfiguration.class)
@ConditionalOnProperty(value = "spring.zipkin.enabled", matchIfMissing = true)
public class DuibaZipkinAutoConfiguration {

    @Configuration
    @ConditionalOnClass(RefreshScope.class)
    protected static class RefreshScopedPercentageBasedSamplerConfiguration {
        @Bean
        @RefreshScope
        @ConditionalOnMissingBean
        public Sampler defaultTraceSampler(SamplerProperties config) {
            return new PercentageBasedSampler(config);
        }
    }

    @Configuration
    @ConditionalOnMissingClass("org.springframework.cloud.context.config.annotation.RefreshScope")
    protected static class NonRefreshScopePercentageBasedSamplerConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public Sampler defaultTraceSampler(SamplerProperties config) {
            return new PercentageBasedSampler(config);
        }
    }

    @Bean
    @ConditionalOnProperty(value = "duiba.zipkin.port", matchIfMissing = false)
    public static SpecifiedBeanPostProcessor zipkinLoadBalancerBeanPostProcessor(@Value("${duiba.zipkin.port}") int zipkinPort) {
        return new ZipkinLoadBalancerBeanPostProcessor(zipkinPort);
    }
}
