package cn.com.duibaboot.ext.autoconfigure.data.etcd;

import cn.com.duibaboot.ext.autoconfigure.core.utils.PropertyResolver;
import cn.com.duibaboot.ext.autoconfigure.data.etcd.client.EtcdKVClientDelegate;
import cn.com.duibaboot.ext.autoconfigure.data.etcd.client.JetcdKVClientDelegate;
import cn.com.duibaboot.ext.autoconfigure.data.etcd.client.RestEtcdKVClientDelegate;
import cn.com.duibaboot.ext.autoconfigure.data.etcd.config.EtcdPropertySourceLocator;
import cn.com.duibaboot.ext.autoconfigure.data.etcd.properties.EtcdProperties;
import cn.com.duibaboot.ext.autoconfigure.datasource.DuibaDataSourceProperties;
import io.etcd.jetcd.Client;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;

import javax.annotation.Resource;
import java.util.List;

/**
 * etcd配置加载
 * Created by gyf .
 * 2018/4/3 .
 * @author gyf
 */
@Slf4j
public class EtcdConfigApplicationContextInitializer implements ApplicationContextInitializer<ConfigurableApplicationContext>, Ordered {

    private int order = Ordered.HIGHEST_PRECEDENCE + 12;

    private static volatile EtcdKVClientDelegate client;

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public void initialize(ConfigurableApplicationContext configurableApplicationContext) {
        ConfigurableEnvironment configurableEnvironment = configurableApplicationContext.getEnvironment();
        PropertyResolver resolver = new PropertyResolver(configurableEnvironment, "duiba.cloud.etcd");
        EtcdProperties etcdProperties = resolver.bindToConfig(EtcdProperties.class);
        try {
            if (client == null) {
                initClient(etcdProperties.getUris());
            }
            EtcdPropertySourceLocator etcdPropertySourceLocator = new EtcdPropertySourceLocator(client, etcdProperties);
            PropertySource<?> propertySource = etcdPropertySourceLocator.locate(configurableEnvironment);
            configurableEnvironment.getPropertySources().addFirst(propertySource);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    private void initClient(List<String> uris){
        try{
            String[] uriArray = uris.toArray(new String[0]);

            Class.forName("io.etcd.jetcd.Client");
            client = new JetcdKVClientDelegate(Client.builder().endpoints(uriArray).build());//NOSONAR
        }catch(ClassNotFoundException e){
            //如果没有引入jetcd，则降级为使用rest版的etcd客户端
            client = new RestEtcdKVClientDelegate(uris);//NOSONAR
        }
    }

}
