package cn.com.duibaboot.ext.autoconfigure.data.etcd;

import cn.com.duibaboot.ext.autoconfigure.data.etcd.properties.EtcdProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 2018/4/3 .
 * @author gyf
 */
@Configuration
@ConditionalOnProperty(value = "duiba.cloud.etcd.enabled", matchIfMissing = true)
public class EtcdConfigBootstrapConfiguration {

    @Bean
    public EtcdConfigApplicationContextInitializer etcdConfigApplicationContextInitializer() {
        return new EtcdConfigApplicationContextInitializer();
    }

}
