package cn.com.duibaboot.ext.autoconfigure.data.etcd.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

import static java.util.Collections.singletonList;

/**
 * @author liuyao
 */
@Data
@ConfigurationProperties("duiba.cloud.etcd")
@Validated
public class EtcdProperties {

    private boolean enabled = true;

    private String prefix = "config";

    @NotNull
    private List<String> uris = new ArrayList<>(singletonList("http://127.0.0.1:2379"));
}
