package cn.com.duibaboot.ext.autoconfigure.data.hbase;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.HTableInterfaceFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.data.hadoop.hbase.HbaseTemplate;

/**
 * 这个HbaseTemplate的包装类是为了在应用退出前清理Connection
 */
class WrappedHbaseTemplate extends HbaseTemplate implements DisposableBean {

    public WrappedHbaseTemplate(Configuration configuration) {
        super(configuration);
    }

    @Override
    public void destroy() throws Exception {
        HTableInterfaceFactory factory = super.getTableFactory();
        if(factory != null && factory instanceof HTableConnectionFactory) {
            ((HTableConnectionFactory)factory).destroy();
        }
    }
}
