package cn.com.duibaboot.ext.autoconfigure.grouping.filter;

import cn.com.duiba.boot.netflix.ribbon.RibbonServerListFilter;
import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duibaboot.ext.autoconfigure.core.utils.ReactiveHttpRequestUtils;
import cn.com.duibaboot.ext.autoconfigure.grouping.ReactiveServiceGroupUtils;
import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupUtils;
import cn.com.duibaboot.ext.autoconfigure.initserver.environment.DeployEnvironment;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

import java.util.HashMap;
import java.util.Map;

/**
 * 服务分组用的Filter，当从request中识别到需要分组的请求时，设置attribute；
 * Created by guoyanfei .
 * 2018/11/7 .
 */
@Slf4j
@Order(Ordered.HIGHEST_PRECEDENCE + 3)
public class ReactiveServiceGroupFilter implements WebFilter {

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        String groupKey = ReactiveServiceGroupUtils.getDuibaServiceGroupKey(exchange.getRequest());
        DeployEnvironment environment = DeployEnvironment.getCurrentEnvironment();
        //开发环境获取ip作为服务分组id，以实现优先调用开发者本地服务的逻辑,以提升开发效率
        if(groupKey == null && environment== DeployEnvironment.DEV){
            String ip = ReactiveHttpRequestUtils.getIpAddr(exchange.getRequest());
            if(ip.equals("127.0.0.1")){
                ip = NetUtils.getLocalIp();
            }
            groupKey = ServiceGroupUtils.DUIBA_SERVICE_GROUP_IP_PREFIX + ip;
        }

        if (StringUtils.isNotBlank(groupKey)) {
            //约定ribbon的loadBalancerKey为Map<String, Object>
            Map<String, Object> loadBalancerInfo = exchange.getAttribute(RibbonServerListFilter.GATEWAY_LOAD_BALANCER_KEY_ATTR);
            if(loadBalancerInfo == null){
                loadBalancerInfo = new HashMap<>();
                exchange.getAttributes().put(RibbonServerListFilter.GATEWAY_LOAD_BALANCER_KEY_ATTR, loadBalancerInfo);
            }
            loadBalancerInfo.put(ServiceGroupUtils.DUIBA_SERVICE_GROUP_KEY, groupKey);
        }

        return chain.filter(exchange);
    }
}
