package cn.com.duibaboot.ext.autoconfigure.grouping.filter;

import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupContext;
import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupUtils;
import cn.com.duibaboot.ext.autoconfigure.initserver.environment.DeployEnvironment;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

/**
 * 服务分组用的Filter；
 * 1. 当从request中识别到需要分组的请求时，设置context
 *
 * Created by guoyanfei .
 * 2018/11/7 .
 * @author liuyao
 */
@Slf4j
public class ServiceGroupFilter implements Filter {

    @Autowired(required = false)
    private List<ServiceGroupHandler> handlerList;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        //do nothing
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String groupKey = ServiceGroupUtils.getDuibaServiceGroupKey((HttpServletRequest) request);
        HttpServletRequest req = (HttpServletRequest) request;
        HttpServletResponse resp = (HttpServletResponse) response;
        DeployEnvironment environment = DeployEnvironment.getCurrentEnvironment();
        //开发环境获取ip作为服务分组id，以实现优先调用开发者本地服务的逻辑,以提升开发效率
        if(groupKey == null && environment== DeployEnvironment.DEV){
            String ip = RequestTool.getIpAddr(req);
            if(ip.equals("127.0.0.1")){
                ip = NetUtils.getLocalIp();
            }
            groupKey = ServiceGroupUtils.DUIBA_SERVICE_GROUP_IP_PREFIX + ip;
        }

        if (StringUtils.isNotBlank(groupKey)) {
            ServiceGroupContext.setGroupKey(groupKey);
        }
        if(Objects.nonNull(handlerList)){
            for (ServiceGroupHandler handler:handlerList){
                if(handler.support(req,resp)){
                    handler.doHandler(req,resp);
                    return;
                }
            }
        }

        try {
            chain.doFilter(request, response);
        } finally {
            ServiceGroupContext.removeGroupKey();
        }
    }

    @Override
    public void destroy() {
        //do nothing
    }
}
