package cn.com.duibaboot.ext.autoconfigure.threadpool.proxy;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.cat.context.CatConstants;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Transaction;
import com.google.common.base.Throwables;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;

import static org.slf4j.LoggerFactory.getLogger;

/**
 * 增加cat/DBTimeProfile监控耗时的功能
 */
public class ProfileCallable extends MonitorCallable {

    private static final Logger logger = getLogger(ProfileCallable.class);

    private String threadPoolName;

    public ProfileCallable(Callable callable) {
        super(callable);
    }

    public ProfileCallable(Callable callable, BlockingQueue<Runnable> queue, String threadPoolName, int maxWaitTimeMillis) {
        super(callable, queue, maxWaitTimeMillis);
        this.threadPoolName = threadPoolName;
    }

    @Override
    public Object call() throws Exception {
        if(CatUtils.isCatEnabled()){

            //如果CAT是启用的 记录执行耗时到CAT
            DBTimeProfile.start();
            Transaction t = Cat.newTransaction(CatConstants.THREAD_POOL, threadPoolName);
            CatUtils.newCompletedTransaction(CatConstants.THREAD_POOL, threadPoolName+".queue.wait", getSubmitTimeNano());
            try {
                Object obj = super.call();
                t.setStatus(Message.SUCCESS);
                return obj;
            } catch (Throwable throwable) {
                t.setStatus(throwable);
                if (nestOverLimit(throwable)) {
                    throw new Exception("abnormal throwable: 【" + throwable.getClass().getName() + "】, stacktrace: 【" + ExceptionUtils.getStackTrace(throwable) + "】");
                }
                logger.error("", throwable);
                throw Throwables.propagate(throwable);
            } finally{
                String rootCallableClassName = getRootCallable().getClass().getName();
                t.addData("method", rootCallableClassName);
                t.complete();
                DBTimeProfile.end(rootCallableClassName + ", thread:" + Thread.currentThread().getName());
            }


        }else{
            DBTimeProfile.start();
            try {
                return super.call();
            } catch (Throwable throwable) {
                if (nestOverLimit(throwable)) {
                    throw new Exception("abnormal throwable: 【" + throwable.getClass().getName() + "】, stacktrace: 【" + ExceptionUtils.getStackTrace(throwable) + "】");
                }
                logger.error("", throwable);
                throw Throwables.propagate(throwable);
            } finally {
                String rootCallableClassName = getRootCallable().getClass().getName();
                DBTimeProfile.end(rootCallableClassName + ", thread:" + Thread.currentThread().getName());
            }
        }
    }



    /**
     * 判断异常嵌套层次是否过深
     *
     * @param t
     * @return true 嵌套超过20层
     */
    private boolean nestOverLimit(Throwable t) {
        int nestTime = 0;
        while (t != null) {
            if (nestTime > 20) {
                logger.error("detect abnormal exception:{}, msg={}", t.getClass().getName(), t.getMessage());
                return true;
            }
            t = t.getCause();
            nestTime++;
        }
        return false;
    }
}
