/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.zipkin;

import brave.sampler.Sampler;
import cn.com.duibaboot.ext.autoconfigure.cloud.zipkin.PercentageBasedSampler;
import cn.com.duibaboot.ext.autoconfigure.cloud.zipkin.ZipkinLoadBalancerBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.cloud.sleuth.sampler.SamplerProperties;
import org.springframework.cloud.sleuth.zipkin2.ZipkinAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import zipkin2.Span;

@Configuration
@ConditionalOnClass(value={Span.class, ZipkinAutoConfiguration.class})
@EnableConfigurationProperties(value={SamplerProperties.class})
@AutoConfigureBefore(value={ZipkinAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.zipkin.enabled"}, matchIfMissing=true)
public class DuibaZipkinAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"duiba.zipkin.port"}, matchIfMissing=false)
    public static SpecifiedBeanPostProcessor zipkinLoadBalancerBeanPostProcessor(@Value(value="${duiba.zipkin.port}") int zipkinPort) {
        return new ZipkinLoadBalancerBeanPostProcessor(zipkinPort);
    }

    @Configuration
    @ConditionalOnMissingClass(value={"org.springframework.cloud.context.config.annotation.RefreshScope"})
    protected static class NonRefreshScopePercentageBasedSamplerConfiguration {
        protected NonRefreshScopePercentageBasedSamplerConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public Sampler defaultTraceSampler(SamplerProperties config) {
            return new PercentageBasedSampler(config);
        }
    }

    @Configuration
    @ConditionalOnClass(value={RefreshScope.class})
    protected static class RefreshScopedPercentageBasedSamplerConfiguration {
        protected RefreshScopedPercentageBasedSamplerConfiguration() {
        }

        @Bean
        @RefreshScope
        @ConditionalOnMissingBean
        public Sampler defaultTraceSampler(SamplerProperties config) {
            return new PercentageBasedSampler(config);
        }
    }
}

