/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.data.etcd;

import cn.com.duibaboot.ext.autoconfigure.data.etcd.actuate.EtcdEndpoint;
import cn.com.duibaboot.ext.autoconfigure.data.etcd.actuate.EtcdLastRefreshStateEndpoint;
import cn.com.duibaboot.ext.autoconfigure.data.etcd.client.EtcdKVClientDelegate;
import cn.com.duibaboot.ext.autoconfigure.data.etcd.client.JetcdKVClientDelegate;
import cn.com.duibaboot.ext.autoconfigure.data.etcd.client.RestEtcdKVClientDelegate;
import cn.com.duibaboot.ext.autoconfigure.data.etcd.properties.EtcdProperties;
import io.etcd.jetcd.Client;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"duiba.cloud.etcd.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={EtcdProperties.class})
public class EtcdAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={Endpoint.class})
    protected static class EtcdHealthConfig {
        protected EtcdHealthConfig() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnAvailableEndpoint
        public EtcdLastRefreshStateEndpoint etcdLastRefreshStateEndpoint() {
            return new EtcdLastRefreshStateEndpoint();
        }
    }

    @Configuration
    @ConditionalOnMissingClass(value={"io.etcd.jetcd.Client"})
    public static class SimpleRestEtcdClientConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={EtcdKVClientDelegate.class})
        public EtcdKVClientDelegate etcdKvClientDelegate(EtcdProperties etcdProperties) {
            return new RestEtcdKVClientDelegate(etcdProperties.getUris());
        }
    }

    @Configuration
    @ConditionalOnClass(value={Client.class})
    @ConditionalOnMissingBean(value={Client.class})
    public static class JetcdConfiguration {
        @Bean
        public Client etcdClient(EtcdProperties etcdProperties) {
            return Client.builder().endpoints(etcdProperties.getUris().toArray(new String[0])).build();
        }

        @Bean
        @ConditionalOnMissingBean(value={EtcdKVClientDelegate.class})
        public EtcdKVClientDelegate etcdKvClientDelegate(Client etcdClient) {
            return new JetcdKVClientDelegate(etcdClient);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnAvailableEndpoint
        public EtcdEndpoint etcdEndpoint(Client etcdClient, EtcdProperties etcdProperties) {
            return new EtcdEndpoint(etcdClient, etcdProperties);
        }
    }
}

