/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.data.etcd;

import cn.com.duibaboot.ext.autoconfigure.core.utils.PropertyResolver;
import cn.com.duibaboot.ext.autoconfigure.data.etcd.client.EtcdKVClientDelegate;
import cn.com.duibaboot.ext.autoconfigure.data.etcd.client.JetcdKVClientDelegate;
import cn.com.duibaboot.ext.autoconfigure.data.etcd.client.RestEtcdKVClientDelegate;
import cn.com.duibaboot.ext.autoconfigure.data.etcd.config.EtcdPropertySourceLocator;
import cn.com.duibaboot.ext.autoconfigure.data.etcd.properties.EtcdProperties;
import io.etcd.jetcd.Client;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public class EtcdConfigApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(EtcdConfigApplicationContextInitializer.class);
    private int order = -2147483636;
    private static volatile EtcdKVClientDelegate client;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void initialize(ConfigurableApplicationContext configurableApplicationContext) {
        ConfigurableEnvironment configurableEnvironment = configurableApplicationContext.getEnvironment();
        PropertyResolver resolver = new PropertyResolver((Environment)configurableEnvironment, "duiba.cloud.etcd");
        EtcdProperties etcdProperties = resolver.bindToConfig(EtcdProperties.class);
        try {
            if (client == null) {
                this.initClient(etcdProperties.getUris());
            }
            EtcdPropertySourceLocator etcdPropertySourceLocator = new EtcdPropertySourceLocator(client, etcdProperties);
            PropertySource<?> propertySource = etcdPropertySourceLocator.locate((Environment)configurableEnvironment);
            configurableEnvironment.getPropertySources().addFirst(propertySource);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void initClient(List<String> uris) {
        try {
            String[] uriArray = uris.toArray(new String[0]);
            Class.forName("io.etcd.jetcd.Client");
            client = new JetcdKVClientDelegate(Client.builder().endpoints(uriArray).build());
        }
        catch (ClassNotFoundException e) {
            client = new RestEtcdKVClientDelegate(uris);
        }
    }
}

