/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.data.etcd.actuate;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class EtcdHealthIndicator
extends AbstractHealthIndicator {
    private static final Logger log = LoggerFactory.getLogger(EtcdHealthIndicator.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(EtcdHealthIndicator.class);
    private final Client etcdClient;

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        try {
            String randomKey = UUID.randomUUID().toString();
            this.etcdClient.getKVClient().get(ByteSequence.from((String)randomKey, (Charset)StandardCharsets.UTF_8)).get(5L, TimeUnit.SECONDS);
            builder.up();
        }
        catch (Exception e) {
            LOGGER.error("EtcdHealthIndicator error ", (Throwable)e);
            builder.down();
        }
    }

    public EtcdHealthIndicator(Client etcdClient) {
        this.etcdClient = etcdClient;
    }
}

