/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.data.etcd.config;

import cn.com.duibaboot.ext.autoconfigure.data.etcd.actuate.EtcdLastRefreshStateEndpoint;
import cn.com.duibaboot.ext.autoconfigure.data.etcd.client.EtcdKVClientDelegate;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.EnumerablePropertySource;

public class EtcdPropertySource
extends EnumerablePropertySource<EtcdKVClientDelegate> {
    private static final Logger log = LoggerFactory.getLogger(EtcdPropertySource.class);
    private Map<String, String> properties = new HashMap<String, String>();
    private final String prefix;
    private static volatile Map<String, String> lastValidProperties = new HashMap<String, String>();

    public EtcdPropertySource(String root, EtcdKVClientDelegate source) {
        super(root, (Object)source);
        this.prefix = root.startsWith("/") ? root + "/" : "/" + root + "/";
    }

    public void init() {
        try {
            Map<String, String> kvs = ((EtcdKVClientDelegate)this.getSource()).getWithPrefix(this.prefix);
            if (kvs.size() > 0) {
                this.process(kvs);
            }
            EtcdLastRefreshStateEndpoint.markSuccess();
        }
        catch (Exception e) {
            log.warn("Unable to init property source: " + this.getName(), (Throwable)e);
            EtcdLastRefreshStateEndpoint.markFail();
        }
        if (this.properties.size() == 0) {
            this.properties = lastValidProperties;
        } else {
            lastValidProperties = this.properties;
        }
    }

    @NotNull
    public String[] getPropertyNames() {
        return this.properties.keySet().toArray(new String[0]);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    private void process(Map<String, String> kvs) {
        for (Map.Entry<String, String> kv : kvs.entrySet()) {
            String key = kv.getKey();
            String value = kv.getValue();
            key = key.substring(this.prefix.length());
            this.properties.put(key.replace("/", "."), value);
        }
    }
}

