/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.devtools;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.springframework.boot.context.event.ApplicationStartingEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.Order;

@Order(value=-2147483648)
public class DevToolsApplicationStartingListener
implements ApplicationListener<ApplicationStartingEvent> {
    private static final String DEVTOOLS_RESTART_KEY = "spring.devtools.restart.enabled";

    public void onApplicationEvent(ApplicationStartingEvent event) {
        if (System.getProperty(DEVTOOLS_RESTART_KEY) != null) {
            return;
        }
        Properties properties = new Properties();
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("bootstrap.properties");){
            if (in != null) {
                properties.load(in);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("load bootstrap.properties failed", e);
        }
        String val = properties.getProperty(DEVTOOLS_RESTART_KEY);
        if (val != null) {
            System.setProperty(DEVTOOLS_RESTART_KEY, val);
            return;
        }
        System.setProperty(DEVTOOLS_RESTART_KEY, "false");
    }
}

