/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.elasticjob;

import cn.com.duiba.boot.utils.NetUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.elasticjob.autoconfigure.eventbus.JobEventCacheStorage;
import io.elasticjob.lite.api.ElasticJob;
import io.elasticjob.lite.api.ShardingContext;
import io.elasticjob.lite.api.dataflow.DataflowJob;
import io.elasticjob.lite.api.script.ScriptJob;
import io.elasticjob.lite.api.simple.SimpleJob;
import io.elasticjob.lite.event.type.JobExecutionEvent;
import io.elasticjob.lite.executor.ShardingContexts;
import io.elasticjob.lite.util.concurrent.ExecutorServiceObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;

public class ElasticjobMonitorManager {
    private static final Logger log = LoggerFactory.getLogger(ElasticjobMonitorManager.class);
    @Autowired
    private ApplicationContext applicationContext;
    private Map<String, String> jobCronMap = Maps.newConcurrentMap();
    private final Set<ElasticJob> runingJob = Sets.newConcurrentHashSet();
    private volatile String jobNamespace;
    private final ExecutorService executorService = new ExecutorServiceObject("monitor-job-trigger", Runtime.getRuntime().availableProcessors() * 2).createExecutorService();

    void setJobNamespace(String namespace) {
        this.jobNamespace = namespace;
    }

    String getJobNamespace() {
        return this.jobNamespace;
    }

    void putJobCronMap(String jobName, String cron) {
        this.jobCronMap.put(jobName, cron);
    }

    String getJobCron(String jobName) {
        return this.jobCronMap.get(jobName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String trigger(String jobClassName, List<Integer> shardingItems) {
        String message;
        ElasticJob elasticJob;
        block22: {
            String string;
            block21: {
                String string2;
                block20: {
                    if (CollectionUtils.isEmpty(shardingItems)) {
                        return "\u6ca1\u6709\u5206\u7247\u4fe1\u606f";
                    }
                    elasticJob = null;
                    message = "\u89e6\u53d1\u4f5c\u4e1a\u5f02\u5e38";
                    try {
                        Class<?> jobClass = Class.forName(jobClassName);
                        io.elasticjob.autoconfigure.annotation.ElasticJob an = (io.elasticjob.autoconfigure.annotation.ElasticJob)AnnotationUtils.findAnnotation(jobClass, io.elasticjob.autoconfigure.annotation.ElasticJob.class);
                        if (an == null || StringUtils.isEmpty((CharSequence)an.name())) {
                            String string3 = "\u76ee\u524d\u53ea\u652f\u6301\u6709job\u6ce8\u89e3\u7684\u89e6\u53d1";
                            return string3;
                        }
                        Map beanMap = this.applicationContext.getBeansOfType(jobClass);
                        if (beanMap == null || beanMap.size() == 0) {
                            String string4 = "\u6ca1\u6709\u627e\u5230\u53ef\u4ee5\u89e6\u53d1\u7684job\u793a\u4f8b";
                            return string4;
                        }
                        Map.Entry entry = beanMap.entrySet().iterator().next();
                        if (!(entry.getValue() instanceof ElasticJob)) {
                            String string5 = "\u6ca1\u6709\u627e\u5230\u53ef\u4ee5\u89e6\u53d1\u7684job\u793a\u4f8b";
                            if (elasticJob == null) return string5;
                            this.runingJob.remove(elasticJob);
                            return string5;
                        }
                        elasticJob = (ElasticJob)entry.getValue();
                        if (this.runingJob.contains(elasticJob)) {
                            string2 = "\u5f53\u524djob\u6b63\u5728\u8fd0\u884c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5";
                            if (elasticJob == null) return string2;
                            break block20;
                        }
                        if (elasticJob instanceof ScriptJob) {
                            string = "\u6682\u65f6\u4e0d\u652f\u6301\u624b\u52a8\u8c03\u5ea6ScriptJob";
                            if (elasticJob == null) return string;
                            break block21;
                        }
                        this.runingJob.add(elasticJob);
                        if (elasticJob instanceof SimpleJob) {
                            this.simpleProcess(elasticJob, shardingItems, an.name());
                        } else if (elasticJob instanceof DataflowJob) {
                            this.dataProcess(elasticJob, shardingItems, an.name());
                        }
                        message = "\u89e6\u53d1\u4f5c\u4e1a\u6210\u529f";
                        if (elasticJob == null) return message;
                        break block22;
                    }
                    catch (Exception e) {
                        log.error("\u89e6\u53d1\u4f5c\u4e1a\u5f02\u5e38", (Throwable)e);
                        return message;
                    }
                }
                this.runingJob.remove(elasticJob);
                return string2;
            }
            this.runingJob.remove(elasticJob);
            return string;
        }
        this.runingJob.remove(elasticJob);
        return message;
        finally {
            if (elasticJob != null) {
                this.runingJob.remove(elasticJob);
            }
        }
    }

    private void simpleProcess(ElasticJob elasticJob, List<Integer> shardingItems, String jobName) {
        String taskId = this.buildTaskId(jobName, shardingItems);
        ShardingContexts empty = new ShardingContexts(taskId, jobName, 0, null, (Map)Maps.newHashMap());
        CountDownLatch latch = new CountDownLatch(shardingItems.size());
        shardingItems.forEach(shardingItem -> this.executorService.submit(() -> {
            try {
                JobExecutionEvent jobExecutionEvent = new JobExecutionEvent(taskId, jobName, null, shardingItem.intValue());
                ((SimpleJob)elasticJob).execute(new ShardingContext(empty, shardingItem.intValue()));
                jobExecutionEvent = jobExecutionEvent.executionSuccess();
                JobEventCacheStorage.addJobExecutionEvent((JobExecutionEvent)jobExecutionEvent);
            }
            finally {
                latch.countDown();
            }
        }));
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    private String buildTaskId(String jobName, List<Integer> shardingItems) {
        String instanceId = String.format("%s@-@1", NetUtils.getLocalIp());
        return Joiner.on((String)"@-@").join((Object)jobName, (Object)Joiner.on((String)",").join(shardingItems), new Object[]{"READY", instanceId});
    }

    private void dataProcess(ElasticJob elasticJob, List<Integer> shardingItems, String jobName) {
        String taskId = this.buildTaskId(jobName, shardingItems);
        CountDownLatch latch = new CountDownLatch(shardingItems.size());
        ShardingContexts empty = new ShardingContexts(null, null, 0, null, (Map)Maps.newHashMap());
        shardingItems.forEach(shardingItem -> this.executorService.submit(() -> {
            try {
                JobExecutionEvent jobExecutionEvent = new JobExecutionEvent(taskId, jobName, null, shardingItem.intValue());
                DataflowJob job = (DataflowJob)elasticJob;
                ShardingContext context = new ShardingContext(empty, shardingItem.intValue());
                List data = job.fetchData(context);
                job.processData(context, data);
                jobExecutionEvent = jobExecutionEvent.executionSuccess();
                JobEventCacheStorage.addJobExecutionEvent((JobExecutionEvent)jobExecutionEvent);
            }
            finally {
                latch.countDown();
            }
        }));
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }
}

