/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.httpclient.ssre;

import cn.com.duiba.boot.utils.AopTargetUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.ClientWrapper;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.SsreAsyncRestTemplateWrapper;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.SsreHttpAsyncClientWrapper;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.SsreHttpClientWrapper;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.SsreRestTemplateWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class SsreBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(SsreBeanPostProcessor.class);
    private final Set<String> whitePackages = Sets.newLinkedHashSet();
    private final Map<Class<?>, Class<? extends ClientWrapper>> acceptableClassesMap;

    public SsreBeanPostProcessor() {
        this.whitePackages.add("cn.com.duibaboot");
        this.whitePackages.add("org.springframework");
        this.whitePackages.add("com.netflix");
        this.whitePackages.add("org");
        this.whitePackages.add("io");
        ArrayList wrapperClassSet = Lists.newArrayList();
        wrapperClassSet.add(new SsreHttpClientWrapper());
        wrapperClassSet.add(new SsreHttpAsyncClientWrapper());
        wrapperClassSet.add(new SsreRestTemplateWrapper());
        wrapperClassSet.add(new SsreAsyncRestTemplateWrapper());
        HashMap acceptableClassesMapTemp = new HashMap();
        for (ClientWrapper w : wrapperClassSet) {
            acceptableClassesMapTemp.put(w.acceptableClass(), w.getClass());
        }
        this.acceptableClassesMap = acceptableClassesMapTemp;
    }

    public Object postProcessBeforeInitialization(@NotNull Object bean, @NotNull String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(@NotNull Object bean, @NotNull String beanName) throws BeansException {
        Object targetBean;
        try {
            targetBean = AopTargetUtils.getTarget((Object)bean);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Class<?> clazz = targetBean.getClass();
        if (!this.checkPackage(clazz.getPackage())) {
            return bean;
        }
        List<Field> fields = this.getFieldList(clazz);
        for (Field field : fields) {
            Class<?> fieldType;
            Class<? extends ClientWrapper> clientWrapperClass;
            if (field.isAnnotationPresent(CanAccessInsideNetwork.class) || (clientWrapperClass = this.getClientWrapperClass(fieldType = field.getType())) == null) continue;
            try {
                ClientWrapper clientWrapper;
                field.setAccessible(true);
                Object obj = field.get(targetBean);
                if (obj == null || clientWrapperClass.isAssignableFrom(obj.getClass()) || !(clientWrapper = clientWrapperClass.newInstance()).trySetClient(obj)) continue;
                field.set(targetBean, clientWrapper);
            }
            catch (Exception e) {
                log.warn("Client\u4ee3\u7406\u5931\u8d25", (Throwable)e);
            }
        }
        return bean;
    }

    private Class<? extends ClientWrapper> getClientWrapperClass(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return null;
        }
        for (Map.Entry<Class<?>, Class<ClientWrapper>> entry : this.acceptableClassesMap.entrySet()) {
            Class<?> c = entry.getKey();
            if (!c.isAssignableFrom(clazz)) continue;
            return entry.getValue();
        }
        return null;
    }

    public void setWhitePackage(Set<String> whitePackage) {
        this.whitePackages.addAll(whitePackage);
    }

    private List<Field> getFieldList(Class<?> clazz) {
        if (null == clazz || Objects.equals(clazz, Object.class)) {
            return Collections.emptyList();
        }
        Object[] fields = clazz.getDeclaredFields();
        ArrayList fieldList = Lists.newArrayList((Object[])fields);
        Class<?> superClass = clazz.getSuperclass();
        if (superClass.equals(Object.class)) {
            return fieldList;
        }
        fieldList.addAll(this.getFieldList(superClass));
        return fieldList;
    }

    private boolean checkPackage(Package pkg) {
        if (pkg == null) {
            return false;
        }
        String packageName = pkg.getName();
        for (String whitePackage : this.whitePackages) {
            if (!StringUtils.startsWith((CharSequence)packageName, (CharSequence)whitePackage)) continue;
            return false;
        }
        return true;
    }
}

