/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.initserver.environment;

import cn.com.duibaboot.ext.autoconfigure.initserver.environment.DeployEnvironment;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class ClusterEnvironmentService {
    private static final Logger log = LoggerFactory.getLogger(ClusterEnvironmentService.class);
    private static final String CLUSTER_PREFIX = "cluster_";
    public static final String DEFAULT_CLUSTER_KEY = "default";
    @Resource
    private Environment environment;
    @Resource
    private DeployEnvironment deployEnvironment;
    private String clusterKey = "default";

    @PostConstruct
    public void init() {
        String profiles = this.environment.getProperty("spring.profiles.active", DeployEnvironment.DEV.getEnvId());
        String[] profileArray = StringUtils.commaDelimitedListToStringArray((String)profiles);
        this.clusterKey = DEFAULT_CLUSTER_KEY;
        for (String profile : profileArray) {
            if (StringUtils.startsWithIgnoreCase((String)profile, (String)CLUSTER_PREFIX)) {
                this.clusterKey = profile.replace(CLUSTER_PREFIX, "");
            }
            if (StringUtils.startsWithIgnoreCase((String)profile, (String)"dev")) {
                this.clusterKey = "dev";
            }
            if (!StringUtils.startsWithIgnoreCase((String)profile, (String)"pre")) continue;
            this.clusterKey = "pre";
        }
    }

    public String currentClusterKey() {
        return this.clusterKey;
    }

    public DeployEnvironment getCurrentEnvironment() {
        return this.deployEnvironment;
    }
}

