/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.initserver.environment;

import cn.com.duibaboot.ext.autoconfigure.initserver.environment.ApplicationEnvironmentProperties;
import cn.com.duibaboot.ext.autoconfigure.initserver.environment.ClusterEnvironmentService;
import cn.com.duibaboot.ext.autoconfigure.initserver.environment.DeployEnvironment;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@EnableConfigurationProperties(value={ApplicationEnvironmentProperties.class})
public class DeployEnvironmentBootConfiguration {
    @Resource
    private ApplicationEnvironmentProperties applicationProperties;

    @Bean
    public DeployEnvironment deployEnvironment(Environment environment) {
        String[] profileArray;
        DeployEnvironment environmentForConfig = this.applicationProperties.getEnvironment();
        if (environmentForConfig != null) {
            DeployEnvironment.setCurrentEnvironment(environmentForConfig);
            return environmentForConfig;
        }
        String profiles = environment.getProperty("spring.profiles.active", DeployEnvironment.DEV.getEnvId());
        for (String profile : profileArray = StringUtils.commaDelimitedListToStringArray((String)profiles)) {
            DeployEnvironment current = DeployEnvironment.getEnvByPrefix(profile);
            if (!Objects.nonNull(current)) continue;
            DeployEnvironment.setCurrentEnvironment(current);
            return current;
        }
        DeployEnvironment.setCurrentEnvironment(DeployEnvironment.DEV);
        return DeployEnvironment.DEV;
    }

    @Bean
    public ClusterEnvironmentService clusterEnvironmentService() {
        return new ClusterEnvironmentService();
    }
}

