/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.logger.accesslog;

import cn.com.duiba.boot.perftest.ReactivePerfTestUtils;
import cn.com.duibaboot.ext.autoconfigure.core.utils.ReactiveHttpRequestUtils;
import cn.com.duibaboot.ext.autoconfigure.logger.accesslog.AbstractAccessLogFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpCookie;
import org.springframework.http.ResponseCookie;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class AccessLogReactiveFilter
extends AbstractAccessLogFilter<ServerWebExchange, ServerHttpResponse>
implements WebFilter {
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        exchange.getRequest();
        long start = System.currentTimeMillis();
        this.doBefore(exchange, exchange.getResponse());
        return chain.filter(exchange).then(Mono.fromRunnable(() -> this.doAfter(exchange, exchange.getResponse(), System.currentTimeMillis() - start)));
    }

    @Override
    protected String getRequestURI(ServerWebExchange req) {
        return req.getRequest().getURI().getPath();
    }

    @Override
    protected String getMethod(ServerWebExchange req) {
        return req.getRequest().getMethodValue();
    }

    @Override
    protected String getQueryString(ServerWebExchange req) {
        return req.getRequest().getURI().getQuery();
    }

    @Override
    protected String getHeader(ServerWebExchange req, String key) {
        return req.getRequest().getHeaders().getFirst(key);
    }

    @Override
    protected String getIpAddr(ServerWebExchange req) {
        return ReactiveHttpRequestUtils.getIpAddr(req.getRequest());
    }

    @Override
    protected void addAttribute(ServerWebExchange req, String key, Object value) {
        req.getAttributes().put(key, value);
    }

    @Override
    protected Object getAttribute(ServerWebExchange req, String key) {
        return req.getAttribute(key);
    }

    @Override
    protected String getParameter(ServerWebExchange req, String key) {
        return (String)req.getRequest().getQueryParams().getFirst((Object)key);
    }

    @Override
    protected List<String> getParameterNames(ServerWebExchange req) {
        MultiValueMap map = req.getRequest().getQueryParams();
        return new ArrayList<String>(map.keySet());
    }

    @Override
    protected int getStatus(ServerHttpResponse resp) {
        return resp.getStatusCode() == null ? 200 : resp.getStatusCode().value();
    }

    @Override
    protected void addCookie(ServerHttpResponse resp, String key, String value, String domain, String path) {
        ResponseCookie.ResponseCookieBuilder cookieBuilder = ResponseCookie.from((String)key, (String)value);
        if (domain != null) {
            cookieBuilder.domain(domain);
        }
        if (path != null) {
            cookieBuilder.path(path);
        }
        resp.addCookie(cookieBuilder.build());
    }

    @Override
    protected boolean isPerfTestRequest(ServerWebExchange req) {
        return ReactivePerfTestUtils.isPerfTestRequest((ServerHttpRequest)req.getRequest());
    }

    @Override
    protected Map<String, String> getCookieMap(ServerWebExchange req) {
        HashMap<String, String> ret = new HashMap<String, String>();
        MultiValueMap map = req.getRequest().getCookies();
        map.forEach((s, httpCookies) -> ret.put((String)s, ((HttpCookie)httpCookies.get(httpCookies.size() - 1)).getValue()));
        return ret;
    }

    @Override
    protected void ensureSafeCall() {
    }
}

