/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest;

import cn.com.duiba.boot.perftest.InternalPerfTestContext;
import cn.com.duiba.boot.utils.AopTargetUtils;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka.DiscoveryMetadataRegister;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.data.etcd.client.EtcdKVClientDelegate;
import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestFootMarker;
import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestRoutingDataSource;
import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestRoutingDataSourceForHikari;
import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestSpringDataRedisPlugin;
import cn.com.duibaboot.ext.autoconfigure.perftest.WebSocketPerfTestConfiguration;
import cn.com.duibaboot.ext.autoconfigure.perftest.filter.PerfTestFilter;
import cn.com.duibaboot.ext.autoconfigure.perftest.filter.PerfTestRejectProperties;
import cn.com.duibaboot.ext.autoconfigure.perftest.filter.ReactivePerfTestFilter;
import cn.com.duibaboot.ext.autoconfigure.perftest.httpclient.HttpAsyncClientPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.perftest.lettuce.LettuceConnectionFactoryBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.perftest.lettuce.LettuceConnectionFactoryMethodInterceptor;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.google.common.base.Throwables;
import com.netflix.hystrix.HystrixCommand;
import com.zaxxer.hikari.HikariDataSource;
import feign.RequestInterceptor;
import feign.hystrix.HystrixFeign;
import io.lettuce.core.RedisClient;
import io.shardingjdbc.core.jdbc.adapter.AbstractDataSourceAdapter;
import io.shardingjdbc.core.jdbc.core.ShardingContext;
import io.shardingjdbc.core.jdbc.core.datasource.MasterSlaveDataSource;
import io.shardingjdbc.core.jdbc.core.datasource.ShardingDataSource;
import io.shardingjdbc.core.rule.MasterSlaveRule;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.datasource.EncryptDataSource;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Import;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.util.ReflectionUtils;
import redis.clients.jedis.Jedis;

@Configuration
@ConditionalOnClass(value={TransmittableThreadLocal.class})
@EnableAspectJAutoProxy(proxyTargetClass=true)
@Import(value={WebSocketPerfTestConfiguration.class, PerfTestRejectProperties.class})
@ConditionalOnResource(resources={"classpath:autoconfig/perftest.properties"})
public class PerfTestAutoConfiguration {
    public static final String IS_PERF_TEST_SUPPORTTED_KEY = "isPerfTestSupportted";

    @PostConstruct
    public void init() {
        if ("true".equals(System.getProperty("duiba.noagent", "false"))) {
            throw new IllegalStateException("\u5f53\u5173\u95edjavaagent\u65f6\u7981\u6b62\u5f15\u5165spring-boot-starter-perftest\u5305, \u5982\u9700\u5f00\u542f\u538b\u6d4b\u652f\u6301\uff0c\u8bf7\u5f00\u542fjavaagent\uff0c\u5426\u5219\u538b\u6d4b\u65f6\u53ef\u80fd\u4f1a\u5bfc\u81f4\u5e72\u6270\u751f\u4ea7\u6570\u636e\u3002");
        }
    }

    @Bean
    public DiscoveryMetadataRegister perftestDiscoveryMetadataRegister() {
        return appMetadata -> appMetadata.put(IS_PERF_TEST_SUPPORTTED_KEY, "1");
    }

    @Configuration
    @ConditionalOnResource(resources={"classpath:autoconfig/perftest.properties"})
    @ConditionalOnClass(value={LettuceConnectionFactory.class, RedisClient.class, Aspect.class})
    public static class PerfTestSpringDataLettucePluginConfiguration {
        @Bean
        public static LettuceConnectionFactoryBeanPostProcessor lettuceConnectionFactoryBeanPostProcessor() {
            return new LettuceConnectionFactoryBeanPostProcessor();
        }

        @Bean
        public LettuceConnectionFactoryMethodInterceptor lettuceConnectionFactoryMethodInterceptor() {
            return new LettuceConnectionFactoryMethodInterceptor();
        }
    }

    @Configuration
    @ConditionalOnResource(resources={"classpath:autoconfig/perftest.properties"})
    @ConditionalOnClass(value={JedisConnectionFactory.class, Jedis.class, Aspect.class})
    public static class PerfTestSpringDataRedisPluginConfiguration {
        @Bean
        public PerfTestSpringDataRedisPlugin perfTestSpringDataRedisPlugin() {
            return new PerfTestSpringDataRedisPlugin();
        }
    }

    @Configuration
    @ConditionalOnResource(resources={"classpath:autoconfig/perftest.properties"})
    @ConditionalOnClass(value={HystrixCommand.class, HystrixFeign.class})
    public class PerfTestFeignConfiguration {
        @Bean
        public RequestInterceptor perfTestFeignRequestInterceptor() {
            return template -> {
                if (InternalPerfTestContext.isCurrentInPerfTestMode()) {
                    template.header("isPerfTestMode", new String[]{"true"});
                    String sceneId = InternalPerfTestContext.getCurrentSceneId();
                    boolean isTestCluster = InternalPerfTestContext.isTestCluster();
                    if (StringUtils.isNotBlank((CharSequence)sceneId)) {
                        template.header("_duibaPerfSceneId", new String[]{sceneId});
                        template.header("_duibaPerfTestCluster", new String[]{String.valueOf(isTestCluster)});
                    }
                }
            };
        }
    }

    @Configuration
    @ConditionalOnResource(resources={"classpath:autoconfig/perftest.properties"})
    @ConditionalOnClass(value={AbstractRoutingDataSource.class, TransmittableThreadLocal.class})
    public static class DataSourceConfigurer {
        @Resource
        private ApplicationContext applicationContext;

        @EventListener(value={EnvironmentChangeEvent.class})
        public void onEnvironmentChange(EnvironmentChangeEvent event) {
            Map map = this.applicationContext.getBeansOfType(PerfTestRoutingDataSource.class);
            if (map == null) {
                return;
            }
            map.values().forEach(perfTestRoutingDataSource -> perfTestRoutingDataSource.onEnvironmentChange(event));
        }

        @Bean
        public static SpecifiedBeanPostProcessor perfTestDataSourcePostProcessor() {
            return new SpecifiedBeanPostProcessor<DataSource>(){
                @Autowired
                Environment environment;
                @Resource
                private ApplicationContext applicationContext;
                private PerfTestFootMarker perfTestFootMarker;

                public int getOrder() {
                    return -2;
                }

                @Override
                public Class<DataSource> getBeanType() {
                    return DataSource.class;
                }

                @Override
                public Object postProcessBeforeInitialization(DataSource bean, String beanName) throws BeansException {
                    return bean;
                }

                @Override
                public Object postProcessAfterInitialization(DataSource bean, String beanName) throws BeansException {
                    if (DataSourceConfigurer.isBeanInstanceOfShardingJdbcDataSource((DataSource)bean, beanName)) {
                        return bean;
                    }
                    if (DataSourceConfigurer.isBeanInstanceOfEncryptDataSource((DataSource)bean, beanName)) {
                        return bean;
                    }
                    if (!(bean instanceof PerfTestRoutingDataSource)) {
                        try {
                            Class.forName("com.zaxxer.hikari.HikariDataSource");
                            if (bean instanceof HikariDataSource) {
                                PerfTestRoutingDataSourceForHikari ts = new PerfTestRoutingDataSourceForHikari((HikariDataSource)bean, this.environment, this.getPerfTestFootMarker());
                                ts.afterPropertiesSet();
                                bean = ts;
                                return bean;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw new IllegalStateException("\u6570\u636e\u6e90\u5fc5\u987b\u5b9a\u4e49\u4e3aHikariDataSource\u6216\u8005BasicDataSource\uff0c\u5426\u5219\u65e0\u6cd5\u652f\u6301\u538b\u6d4b\uff0c\u5982\u679c\u4f60\u9700\u8981\u4e34\u65f6\u8fc1\u79fb\u6570\u636e\u5e93\uff0c\u8bf7\u6682\u65f6\u628aspring-boot-starter-perftest\u5305\u53bb\u6389\uff0c\u5e76\u5728\u8fc1\u79fb\u5b8c\u6210\u540e\u52a0\u56de\u6765");
                    }
                    return bean;
                }

                private PerfTestFootMarker getPerfTestFootMarker() {
                    if (this.perfTestFootMarker == null) {
                        this.perfTestFootMarker = (PerfTestFootMarker)this.applicationContext.getBean(PerfTestFootMarker.class);
                    }
                    return this.perfTestFootMarker;
                }
            };
        }

        private static boolean isBeanInstanceOfEncryptDataSource(DataSource bean, String beanName) {
            try {
                Class.forName("org.apache.shardingsphere.shardingjdbc.jdbc.core.datasource.EncryptDataSource");
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            if (!(bean instanceof EncryptDataSource)) {
                return false;
            }
            EncryptDataSource ds = (EncryptDataSource)bean;
            try {
                ds = (EncryptDataSource)AopTargetUtils.getTarget((Object)ds);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
            Field field = ReflectionUtils.findField(EncryptDataSource.class, (String)"dataSourceMap");
            field.setAccessible(true);
            Map dataSourceMap = (Map)ReflectionUtils.getField((Field)field, (Object)ds);
            for (Map.Entry entry : dataSourceMap.entrySet()) {
                DataSource innerDs = (DataSource)entry.getValue();
                if (innerDs instanceof PerfTestRoutingDataSource) continue;
                throw new IllegalStateException("\u8bf7\u628a\u7684EncryptDataSource\u6570\u636e\u6e90\u5185\u90e8\u4f7f\u7528\u7684\u6570\u636e\u6e90\u6ce8\u518c\u4e3aspring\u7684bean\uff0c\u4ee5\u8ba9\u7ebf\u4e0a\u538b\u6d4b\u6846\u67b6\u6709\u673a\u4f1a\u5904\u7406\u5185\u90e8\u7684\u6570\u636e\u6e90\uff08\u5185\u90e8\u6570\u636e\u6e90\u5fc5\u987b\u4e3adbcp2/Hikari\uff09");
            }
            return true;
        }

        private static boolean isBeanInstanceOfShardingJdbcDataSource(DataSource bean, String beanName) {
            try {
                Class.forName("io.shardingjdbc.core.jdbc.adapter.AbstractDataSourceAdapter");
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            if (!(bean instanceof AbstractDataSourceAdapter)) {
                return false;
            }
            if (bean instanceof ShardingDataSource) {
                ShardingDataSource ds = (ShardingDataSource)bean;
                try {
                    ds = (ShardingDataSource)AopTargetUtils.getTarget((Object)ds);
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
                Field field = ReflectionUtils.findField(ShardingDataSource.class, (String)"shardingContext");
                field.setAccessible(true);
                ShardingContext shardingContext = (ShardingContext)ReflectionUtils.getField((Field)field, (Object)ds);
                Map dataSourceMap = shardingContext.getShardingRule().getDataSourceMap();
                for (Map.Entry entry : dataSourceMap.entrySet()) {
                    DataSource innerDs = (DataSource)entry.getValue();
                    if (innerDs instanceof MasterSlaveDataSource) {
                        DataSourceConfigurer.processMasterSlaveDataSource((DataSource)((MasterSlaveDataSource)innerDs), beanName);
                        continue;
                    }
                    if (innerDs instanceof PerfTestRoutingDataSource) continue;
                    DataSourceConfigurer.onShardingJdbcError(beanName);
                }
            } else if (bean instanceof MasterSlaveDataSource) {
                DataSourceConfigurer.processMasterSlaveDataSource((DataSource)((MasterSlaveDataSource)bean), beanName);
            } else {
                throw new IllegalStateException("[NOTIFYME]sharding jdbc\u65b0\u589e\u7684\u6570\u636e\u6e90\u6682\u65f6\u4e0d\u652f\u6301\uff0c\u5982\u9047\u5230\u6b64\u95ee\u9898\uff0c\u8bf7\u8054\u7cfb\u67b6\u6784\u7ec4\u6dfb\u52a0\u652f\u6301");
            }
            return true;
        }

        private static void processMasterSlaveDataSource(DataSource ds, String beanName) {
            MasterSlaveDataSource ds1 = (MasterSlaveDataSource)ds;
            MasterSlaveRule oriRule = ds1.getMasterSlaveRule();
            DataSource oriMd = oriRule.getMasterDataSource();
            boolean throwException = false;
            if (!(oriMd instanceof PerfTestRoutingDataSource)) {
                throwException = true;
            }
            if (!throwException) {
                Map slaveDataSourceMap = oriRule.getSlaveDataSourceMap();
                for (Map.Entry entry : slaveDataSourceMap.entrySet()) {
                    DataSource innerDs = (DataSource)entry.getValue();
                    if (innerDs instanceof PerfTestRoutingDataSource) continue;
                    throwException = true;
                    break;
                }
            }
            if (throwException) {
                DataSourceConfigurer.onShardingJdbcError(beanName);
            }
        }

        private static void onShardingJdbcError(String beanName) {
            throw new IllegalStateException("\u8bf7\u628aid\u4e3a[" + beanName + "]\u7684sharding-jdbc\u6570\u636e\u6e90\u5185\u90e8\u4f7f\u7528\u7684\u6570\u636e\u6e90\u6ce8\u518c\u4e3aspring\u7684bean\uff0c\u4ee5\u8ba9\u7ebf\u4e0a\u538b\u6d4b\u6846\u67b6\u6709\u673a\u4f1a\u5904\u7406\u5185\u90e8\u7684\u6570\u636e\u6e90\uff08\u5185\u90e8\u6570\u636e\u6e90\u5fc5\u987b\u4e3adbcp2\uff09");
        }
    }

    @Configuration
    @ConditionalOnResource(resources={"classpath:autoconfig/perftest.properties"})
    @ConditionalOnClass(value={CloseableHttpAsyncClient.class})
    public static class HttpAsyncClientPostProcessorConfiguration {
        @Bean
        public static SpecifiedBeanPostProcessor httpAsyncClientPostProcessor() {
            return new HttpAsyncClientPostProcessor();
        }
    }

    @Configuration
    @ConditionalOnResource(resources={"classpath:autoconfig/perftest.properties"})
    @ConditionalOnClass(value={TransmittableThreadLocal.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    static class PerfTestFilterConfigurationReactive {
        PerfTestFilterConfigurationReactive() {
        }

        @Bean
        public ReactivePerfTestFilter reactivePerfTestFilter() {
            return new ReactivePerfTestFilter();
        }
    }

    @Configuration
    @ConditionalOnResource(resources={"classpath:autoconfig/perftest.properties"})
    @ConditionalOnClass(value={TransmittableThreadLocal.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    static class PerfTestFilterConfigurationServlet {
        PerfTestFilterConfigurationServlet() {
        }

        @Bean
        public PerfTestFilter perfTestFilter() {
            return new PerfTestFilter();
        }

        @Bean
        public FilterRegistrationBean perfTestFilterConfigurer(PerfTestFilter perfTestFilter) {
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter((Filter)perfTestFilter);
            ArrayList<String> urlPatterns = new ArrayList<String>();
            urlPatterns.add("/*");
            registrationBean.setUrlPatterns(urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
            registrationBean.setOrder(-2147483645);
            return registrationBean;
        }
    }

    @Configuration
    @ConditionalOnResource(resources={"classpath:autoconfig/perftest.properties"})
    static class PerfTestFootMarkerConfiguration {
        PerfTestFootMarkerConfiguration() {
        }

        @Bean
        public PerfTestFootMarker perfTestFootMarker(@Autowired(required=false) EtcdKVClientDelegate etcdKvClientDelegate) {
            if (Objects.isNull(etcdKvClientDelegate)) {
                throw new RuntimeException("etcd\u5ba2\u6237\u7aef\u672a\u542f\u52a8,\u65e0\u6cd5\u4f7f\u7528\u538b\u529b\u6d4b\u8bd5\u76f8\u5173\u7684\u529f\u80fd");
            }
            return new PerfTestFootMarker(etcdKvClientDelegate);
        }
    }
}

