/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.threadpool.proxy;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.threadpool.proxy.MonitorCallable;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import com.google.common.base.Throwables;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileCallable
extends MonitorCallable {
    private static final Logger logger = LoggerFactory.getLogger(ProfileCallable.class);
    private String threadPoolName;

    public ProfileCallable(Callable callable) {
        super(callable);
    }

    public ProfileCallable(Callable callable, BlockingQueue<Runnable> queue, String threadPoolName, int maxWaitTimeMillis) {
        super(callable, queue, maxWaitTimeMillis);
        this.threadPoolName = threadPoolName;
    }

    @Override
    public Object call() throws Exception {
        if (CatUtils.isCatEnabled()) {
            DBTimeProfile.start();
            Transaction t = Cat.newTransaction((String)"ThreadPool", (String)this.threadPoolName);
            CatUtils.newCompletedTransaction("ThreadPool", this.threadPoolName + ".queue.wait", this.getSubmitTimeNano());
            try {
                Object obj = super.call();
                t.setStatus("0");
                Object object = obj;
                return object;
            }
            catch (Throwable throwable) {
                t.setStatus(throwable);
                if (this.nestOverLimit(throwable)) {
                    throw new Exception("abnormal throwable: \u3010" + throwable.getClass().getName() + "\u3011, stacktrace: \u3010" + ExceptionUtils.getStackTrace((Throwable)throwable) + "\u3011");
                }
                logger.error("", throwable);
                throw Throwables.propagate((Throwable)throwable);
            }
            finally {
                String rootCallableClassName = this.getRootCallable().getClass().getName();
                t.addData("method", (Object)rootCallableClassName);
                t.complete();
                DBTimeProfile.end((String)(rootCallableClassName + ", thread:" + Thread.currentThread().getName()));
            }
        }
        DBTimeProfile.start();
        try {
            Object t = super.call();
            return t;
        }
        catch (Throwable throwable) {
            if (this.nestOverLimit(throwable)) {
                throw new Exception("abnormal throwable: \u3010" + throwable.getClass().getName() + "\u3011, stacktrace: \u3010" + ExceptionUtils.getStackTrace((Throwable)throwable) + "\u3011");
            }
            logger.error("", throwable);
            throw Throwables.propagate((Throwable)throwable);
        }
        finally {
            String rootCallableClassName = this.getRootCallable().getClass().getName();
            DBTimeProfile.end((String)(rootCallableClassName + ", thread:" + Thread.currentThread().getName()));
        }
    }

    private boolean nestOverLimit(Throwable t) {
        int nestTime = 0;
        while (t != null) {
            if (nestTime > 20) {
                logger.error("detect abnormal exception:{}, msg={}", (Object)t.getClass().getName(), (Object)t.getMessage());
                return true;
            }
            t = t.getCause();
            ++nestTime;
        }
        return false;
    }
}

