/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.dubbo.dispatcher;

import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.transport.dispatcher.ChannelEventRunnable;

public class DuibaChannelEventRunnable
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(DuibaChannelEventRunnable.class);
    private final ChannelHandler handler;
    private final Channel channel;
    private final ChannelEventRunnable.ChannelState state;
    private final Throwable exception;
    private final Object message;
    private final long submitNanoTime = System.nanoTime();

    public DuibaChannelEventRunnable(Channel channel, ChannelHandler handler, ChannelEventRunnable.ChannelState state) {
        this(channel, handler, state, null);
    }

    public DuibaChannelEventRunnable(Channel channel, ChannelHandler handler, ChannelEventRunnable.ChannelState state, Object message) {
        this(channel, handler, state, message, null);
    }

    public DuibaChannelEventRunnable(Channel channel, ChannelHandler handler, ChannelEventRunnable.ChannelState state, Throwable t) {
        this(channel, handler, state, null, t);
    }

    public DuibaChannelEventRunnable(Channel channel, ChannelHandler handler, ChannelEventRunnable.ChannelState state, Object message, Throwable exception) {
        this.channel = channel;
        this.handler = handler;
        this.state = state;
        this.message = message;
        this.exception = exception;
    }

    @Override
    public void run() {
        Transaction t = Cat.newTransaction((String)"ThreadPool", (String)"dubbo.channel.runnable");
        CatUtils.newCompletedTransaction((String)"ThreadPool", (String)"dubbo.queue.wait", (long)this.submitNanoTime);
        try {
            this.doRun();
            t.setStatus("0");
        }
        finally {
            t.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun() {
        if (this.state == ChannelEventRunnable.ChannelState.RECEIVED) {
            try {
                this.handler.received(this.channel, this.message);
            }
            catch (Exception e) {
                logger.warn("ChannelEventRunnable handle " + this.state + " operation error, channel is " + this.channel + ", message is " + this.message, (Throwable)e);
            }
        } else {
            switch (this.state) {
                case CONNECTED: {
                    Transaction t = Cat.newTransaction((String)"ThreadPool", (String)"dubbo.connected");
                    try {
                        this.handler.connected(this.channel);
                        t.setStatus("0");
                        break;
                    }
                    catch (Exception e) {
                        logger.warn("ChannelEventRunnable handle " + this.state + " operation error, channel is " + this.channel, (Throwable)e);
                        t.setStatus(e.getMessage());
                        break;
                    }
                    finally {
                        t.complete();
                    }
                }
                case DISCONNECTED: {
                    Transaction t = Cat.newTransaction((String)"ThreadPool", (String)"dubbo.disconnected");
                    try {
                        this.handler.disconnected(this.channel);
                        t.setStatus("0");
                        break;
                    }
                    catch (Exception e) {
                        logger.warn("ChannelEventRunnable handle " + this.state + " operation error, channel is " + this.channel, (Throwable)e);
                        t.setStatus(e.getMessage());
                        break;
                    }
                    finally {
                        t.complete();
                    }
                }
                case SENT: {
                    Transaction t = Cat.newTransaction((String)"ThreadPool", (String)"dubbo.sent");
                    try {
                        this.handler.sent(this.channel, this.message);
                        t.setStatus("0");
                        break;
                    }
                    catch (Exception e) {
                        logger.warn("ChannelEventRunnable handle " + this.state + " operation error, channel is " + this.channel + ", message is " + this.message, (Throwable)e);
                        t.setStatus(e.getMessage());
                        break;
                    }
                    finally {
                        t.complete();
                    }
                }
                case CAUGHT: {
                    Transaction t = Cat.newTransaction((String)"ThreadPool", (String)"dubbo.caught");
                    try {
                        this.handler.caught(this.channel, this.exception);
                        t.setStatus("0");
                    }
                    catch (Exception e) {
                        logger.warn("ChannelEventRunnable handle " + this.state + " operation error, channel is " + this.channel + ", message is: " + this.message + ", exception is " + this.exception, (Throwable)e);
                        t.complete();
                    }
                    break;
                }
                default: {
                    logger.warn("unknown state: " + this.state + ", message is " + this.message);
                }
            }
        }
    }
}

