/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.dubbo.graceclose;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import cn.com.duibaboot.ext.autoconfigure.core.EarlyClose;
import org.apache.dubbo.config.bootstrap.DubboBootstrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DubboGracefulCloseAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(DubboGracefulCloseAutoConfiguration.class);

    @Bean
    public DubboGracefulCloseLifeCycle dubboGracefulCloseLifeCycle() {
        return new DubboGracefulCloseLifeCycle();
    }

    public static class DubboGracefulCloseLifeCycle
    extends EarlyClose {
        public void stop() {
            if (!logger.isInfoEnabled()) {
                LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                loggerContext.getLogger(DubboGracefulCloseAutoConfiguration.class).setLevel(Level.INFO);
            }
            try {
                logger.info("clean up dubbo");
                DubboBootstrap.getInstance().destroy();
            }
            catch (ExceptionInInitializerError loggerContext) {
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
            }
        }

        public int getPhase() {
            return -2;
        }
    }
}

