/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.dubbo.init;

import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import cn.com.duibaboot.ext.autoconfigure.dubbo.core.DubboSpecifiedBeanPostProcessor;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.config.spring.context.event.DubboBootstrapStatedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;

public class DubboBootstrapListenerForAsyncSpecified
implements ApplicationListener<DubboBootstrapStatedEvent>,
Ordered {
    private static final Logger logger = LoggerFactory.getLogger(DubboBootstrapListenerForAsyncSpecified.class);
    private Map<DubboSpecifiedBeanPostProcessor, Map<String, Object>> dubboAsyncProcessor2BeansMap;

    public DubboBootstrapListenerForAsyncSpecified(Map<DubboSpecifiedBeanPostProcessor, Map<String, Object>> dubboAsyncProcessor2BeansMap) {
        this.dubboAsyncProcessor2BeansMap = dubboAsyncProcessor2BeansMap;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void onApplicationEvent(DubboBootstrapStatedEvent event) {
        ExecutorService executorService = Executors.newFixedThreadPool(5, (ThreadFactory)new NamedThreadFactory("DuibaBootDubboInitServerThread-"));
        int totalBean2ProcessCount = 0;
        for (Map<String, Object> map : this.dubboAsyncProcessor2BeansMap.values()) {
            totalBean2ProcessCount += map.size();
        }
        CountDownLatch countDownLatch = new CountDownLatch(totalBean2ProcessCount);
        for (Map.Entry<DubboSpecifiedBeanPostProcessor, Map<String, Object>> entry : this.dubboAsyncProcessor2BeansMap.entrySet()) {
            Map<String, Object> beanMap = entry.getValue();
            DubboSpecifiedBeanPostProcessor processor = entry.getKey();
            for (Map.Entry<String, Object> beanEntry : beanMap.entrySet()) {
                executorService.submit(() -> {
                    try {
                        processor.postProcessAfterInitialization(beanEntry.getValue(), (String)beanEntry.getKey());
                    }
                    catch (Exception e) {
                        logger.warn("Dubbo Init failed", (Throwable)e);
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                });
            }
        }
        try {
            boolean bl = countDownLatch.await(3L, TimeUnit.SECONDS);
            if (!bl) {
                logger.info("\u90e8\u5206\u529f\u80fd\u6ca1\u6709\u521d\u59cb\u5316\u6210\u529f");
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        executorService.shutdown();
    }
}

