package cn.com.duibaboot.ext.autoconfigure.dubbo.graceclose;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import cn.com.duibaboot.ext.autoconfigure.core.EarlyClose;
import org.apache.dubbo.config.bootstrap.DubboBootstrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DubboGracefulCloseAutoConfiguration {

    private static final Logger logger = LoggerFactory.getLogger(DubboGracefulCloseAutoConfiguration.class);

    @Bean
    public DubboGracefulCloseLifeCycle dubboGracefulCloseLifeCycle() {
        return new DubboGracefulCloseLifeCycle();
    }

    /**
     * dubbo 优雅停机
     */
    public static class DubboGracefulCloseLifeCycle extends EarlyClose {

        @Override
        public void stop() {

            if (!logger.isInfoEnabled()) {
                LoggerContext loggerContext = (LoggerContext) LoggerFactory.getILoggerFactory();
                loggerContext.getLogger(DubboGracefulCloseAutoConfiguration.class).setLevel(Level.INFO);
            }

            try {
                logger.info("clean up dubbo");
                DubboBootstrap.getInstance().destroy();
            } catch (ExceptionInInitializerError e) {
                // Ignore
            } catch (Throwable e) {
                logger.error(e.getMessage(), e);
            }
        }

        /**
         * Eureka/Consul的LifeCycle的phase是0，这里设置为-2
         * 1.让本类的stop会在取消注册之后被调用
         * 2.让本类晚于GracefulCloseLifeCycle执行
         *
         * @return
         */
        @Override
        public int getPhase() {
            return -2;
        }
    }
}
