/**
 * Copyright (c) 2022, duiba.com.cn All Rights Reserved.
 */
package cn.com.duibaboot.ext.autoconfigure.dubbo.deploy;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;

/**
 * 描述: 强制覆盖 DubboDeployApplicationListener
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2022/2/24 15:57
 */
public class DeployBeanDefinitionRegistryPostProcessor implements BeanDefinitionRegistryPostProcessor {

    @Override
    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        // 重写 DubboDeployApplicationListener 类
        BeanDefinition beanDefinition = BeanDefinitionBuilder
                .genericBeanDefinition(DubboDeployApplicationListener.class)
                .getBeanDefinition();
        String beanName = org.apache.dubbo.config.spring.context.DubboDeployApplicationListener.class.getName();
        registry.removeBeanDefinition(beanName);
        registry.registerBeanDefinition(beanName, beanDefinition);
    }

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        // nothing
    }
}
