/**
 * Copyright (c) 2022, duiba.com.cn All Rights Reserved.
 */
package cn.com.duibaboot.ext.autoconfigure.dubbo.monitor.rpc;

import cn.com.duibaboot.ext.autoconfigure.monitor.rpc.scan.RpcConsumerScan;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.Reference;

import java.util.ArrayList;
import java.util.List;

/**
 * 描述: rpc 引用扫描
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2022/2/25 16:25
 */
@Slf4j
public class DubboRpcConsumerScan {

    static {
        List<Class> list = new ArrayList<>();
        list.add(Reference.class);
        list.add(com.alibaba.dubbo.config.annotation.Reference.class);
        list.add(DubboReference.class);
        RpcConsumerScan.registerInjectClass(list);
    }

}
