package cn.com.duibaboot.ext.autoconfigure.dubbo.init;

import cn.com.duibaboot.ext.autoconfigure.dubbo.core.DubboSpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.core.DuibaSpecifiedBeanPostProcessor;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by wenqi.huang on 2017/6/16.
 */
public class DubboBeanPostProcessorOfSpecified implements BeanPostProcessor, ApplicationContextAware, Ordered {

    private Map<DubboSpecifiedBeanPostProcessor, Map<String, Object>> dubboAsyncProcessor2BeansMap = new HashMap<>(10);
    private List<DubboSpecifiedBeanPostProcessor> dubboAsyncProcessorList;

    @Override
    public int getOrder() {
        return -2;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {

        //生成需要被dubbo3延迟异步处理的map,方便后续被异步处理
        if (!CollectionUtils.isEmpty(dubboAsyncProcessorList)) {
            genSpecifiedBeanMap(bean, beanName, dubboAsyncProcessorList, dubboAsyncProcessor2BeansMap);
        }

        return bean;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        //找到所有DubboSpecifiedBeanPostProcessor实例
        Map<String, DubboSpecifiedBeanPostProcessor> dubboAsyncProcessorMap = applicationContext.getBeansOfType(DubboSpecifiedBeanPostProcessor.class, false, false);
        List<DubboSpecifiedBeanPostProcessor> dubboAsyncProcessorList = new ArrayList<>(dubboAsyncProcessorMap.values());

        this.dubboAsyncProcessorList = dubboAsyncProcessorList;
    }

    public Map<DubboSpecifiedBeanPostProcessor, Map<String, Object>> getDubboAsyncProcessor2BeansMap() {
        return dubboAsyncProcessor2BeansMap;
    }

    /**
     * 构建duibaSpecifiedBeanPostProcessor
     *
     * @param bean
     * @param beanName
     * @param specifiedBeanList
     * @param specifiedBeanMap
     * @param <T>
     * @see DuibaSpecifiedBeanPostProcessor
     */
    private <T extends DuibaSpecifiedBeanPostProcessor> void genSpecifiedBeanMap(Object bean, String beanName, List<T> specifiedBeanList, Map<T, Map<String, Object>> specifiedBeanMap) {
        for (T t : specifiedBeanList) {
            if (t.getBeanType().isAssignableFrom(bean.getClass())) {
                Map<String, Object> beanMap = specifiedBeanMap.get(t);
                if (beanMap == null) {
                    beanMap = new HashMap<>();
                    specifiedBeanMap.put(t, beanMap);
                }
                beanMap.put(beanName, bean);
            }
        }
    }
}
