/**
 * Copyright (c) 2022, duiba.com.cn All Rights Reserved.
 */
package cn.com.duibaboot.ext.autoconfigure.dubbo.common;

import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.metadata.MetadataParamsFilter;

/**
 * 描述: 升级dubbo3.0后，增加meta data 和 instance 参数
 * <p>
 * 主要目的
 * 1、默认开启meta data中添加timestamp/weight参数，启用负载均衡(修改权重暂时无效，禁用实例有效)
 * 2、instance中默认加入serviceGroupKey，启用多场景
 * 3、instance中默认加入isPerfTestSupportted，启用压测
 * 4、instance中默认加入serverApplicationName，cat监控会用到
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2022/3/25 17:55
 */
@Activate(group = {CommonConstants.PROVIDER})
public class CustomizedMetadataParamsFilter implements MetadataParamsFilter {

    @Override
    public String[] serviceParamsIncluded() {
        return new String[]{"timestamp", "weight"};
    }

    @Override
    public String[] instanceParamsIncluded() {
        return new String[]{"serviceGroupKey", "serverApplicationName", "isPerfTestSupportted", "duibaNewPerfSceneId"};
    }

}
