package cn.com.duibaboot.ext.autoconfigure.dubbo.group;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.cluster.Router;
import org.apache.dubbo.rpc.cluster.RouterFactory;

/**
 * 服务分组用的dubbo路由器工厂
 * Created by gyf .
 * 2020/11/12 .
 */
@Activate(group = CommonConstants.CONSUMER)
public class ServiceGroupDubboRouterFactory implements RouterFactory {

    public static final String NAME = "serviceGroup";

    @Override
    public Router getRouter(URL url) {
        return new ServiceGroupDubboRouter(url);
    }
}
