/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.hazelcast.eureka;

import cn.com.duibaboot.ext.autoconfigure.hazelcast.DuibaHazelcastProperties;
import cn.com.duibaboot.ext.autoconfigure.hazelcast.HazelcastConfigPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.hazelcast.eureka.EurekaOneDiscoveryStrategy;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.hazelcast.config.Config;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.properties.PropertyDefinition;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.DiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryStrategyFactory;
import com.netflix.discovery.EurekaClient;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class EurekaOneDiscoveryStrategyFactory
implements DiscoveryStrategyFactory,
HazelcastConfigPostProcessor {
    static final Collection<PropertyDefinition> PROPERTY_DEFINITIONS = Lists.newArrayList();
    private static EurekaClient eurekaClient;
    private static DuibaHazelcastProperties duibaHazelcastProperties;
    private static ApplicationContext applicationContext;

    public Class<? extends DiscoveryStrategy> getDiscoveryStrategyType() {
        return EurekaOneDiscoveryStrategy.class;
    }

    public DiscoveryStrategy newDiscoveryStrategy(DiscoveryNode discoveryNode, ILogger logger, Map<String, Comparable> properties) {
        EurekaOneDiscoveryStrategy discoveryStrategy = new EurekaOneDiscoveryStrategy(logger, properties);
        discoveryStrategy.setEurekaClient(eurekaClient);
        discoveryStrategy.setCurrentDiscoveryNode(discoveryNode);
        discoveryStrategy.setDuibaHazelcastProperties(duibaHazelcastProperties);
        discoveryStrategy.setApplicationContext(applicationContext);
        return discoveryStrategy;
    }

    public Collection<PropertyDefinition> getConfigurationProperties() {
        return PROPERTY_DEFINITIONS;
    }

    @Autowired(required=false)
    public void setEurekaClient(EurekaClient eurekaClient) {
        EurekaOneDiscoveryStrategyFactory.eurekaClient = eurekaClient;
    }

    @Autowired(required=false)
    public void setDuibaHazelcastProperties(DuibaHazelcastProperties duibaHazelcastProperties) {
        EurekaOneDiscoveryStrategyFactory.duibaHazelcastProperties = duibaHazelcastProperties;
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        EurekaOneDiscoveryStrategyFactory.applicationContext = applicationContext;
    }

    @Override
    public void preProcessor(Config hazelcastConfig) {
        HashMap eurekaStrategyProperties = Maps.newHashMap();
        eurekaStrategyProperties.putAll(duibaHazelcastProperties.getProperties());
        hazelcastConfig.setProperty("hazelcast.discovery.enabled", "true");
        DiscoveryConfig discoveryConfig = hazelcastConfig.getNetworkConfig().getJoin().getDiscoveryConfig();
        discoveryConfig.addDiscoveryStrategyConfig(new DiscoveryStrategyConfig(EurekaOneDiscoveryStrategy.class.getName(), (Map)eurekaStrategyProperties));
    }
}

