package cn.com.duibaboot.ext.autoconfigure.hazelcast.eureka;

import cn.com.duiba.boot.hazelcast.EurekaHazelcastGroupKey;
import com.google.common.base.Joiner;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by guoyanfei .
 * 2022/3/22 .
 */
public class EurekaHazelcastGroupManager {

    private static final Joiner JOINER = Joiner.on("###");

    @Autowired(required = false)
    private List<EurekaHazelcastGroupKey> eurekaHazelcastGroupKeys;

    private String groupKey;

    @PostConstruct
    public void init() {
        // 默认一个都没有，那么groupKey就是为null
        if (CollectionUtils.isEmpty(eurekaHazelcastGroupKeys)) {
            return;
        }
        List<String> keys = new ArrayList<>();
        for (EurekaHazelcastGroupKey it : eurekaHazelcastGroupKeys) {
            String key = it.getKey();
            if (StringUtils.isNotBlank(key)) {
                keys.add(it.getKey());
            }
        }
        if (CollectionUtils.isNotEmpty(keys)) {
            groupKey = JOINER.join(keys);
        }
    }

    /**
     * 获取本地的分组key
     * @return
     */
    public String getLocalGroupKey() {
        return this.groupKey;
    }

    /**
     * 当前的分组key和目标的分组key相同，表示应该在同一组
     * @param targetGroupKey
     * @return
     */
    public boolean isTargetSameGroup(String targetGroupKey) {
        return StringUtils.equals(this.groupKey, targetGroupKey);
    }

}
