/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.data.mongodb;

import brave.Span;
import cn.com.duibaboot.ext.autoconfigure.cat.CatAutoConfiguration;
import cn.com.duibaboot.ext.autoconfigure.core.AsyncSpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.data.mongodb.monitoring.CatSpringDataMongodbPlugin;
import cn.com.duibaboot.ext.autoconfigure.data.mongodb.monitoring.SleuthMongodbPlugin;
import cn.com.duibaboot.ext.autoconfigure.data.mongodb.perftest.SpringDataMongodbPerfAspect;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.dianping.cat.Cat;
import com.mongodb.ConnectionString;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

@Configurable
public class SpringDataMongodbConfigurable {
    private static final Logger log = LoggerFactory.getLogger(SpringDataMongodbConfigurable.class);

    @Configuration
    @ConditionalOnClass(value={Span.class, Aspect.class, MongoOperations.class})
    public static class SleuthMongodbConfiguration {
        @Bean
        public SleuthMongodbPlugin sleuthMongodbPlugin() {
            return new SleuthMongodbPlugin();
        }
    }

    @Configuration
    @Conditional(value={CatAutoConfiguration.CatCondition.class})
    @ConditionalOnClass(value={MongoOperations.class, Cat.class, Aspect.class})
    public static class CatMongodbConfiguration {
        @Bean
        public CatSpringDataMongodbPlugin getCatSpringDataMongodbPlugin() {
            return new CatSpringDataMongodbPlugin();
        }
    }

    @Configuration
    @ConditionalOnClass(value={MongoOperations.class})
    public static class MongoDbPostProcessorConfiguration {
        @Bean
        public static AsyncSpecifiedBeanPostProcessor<MongoOperations> mongoDbPostProcessorConfigurer() {
            return new AsyncSpecifiedBeanPostProcessor<MongoOperations>(){

                public Class<MongoOperations> getBeanType() {
                    return MongoOperations.class;
                }

                public void postProcessAfterInitialization(MongoOperations mongoOperations, String beanName) {
                    try {
                        mongoOperations.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"id").is((Object)"1")), String.class, "test_collection");
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            };
        }
    }

    @Configuration
    @ConditionalOnResource(resources={"classpath:autoconfig/perftest.properties"})
    @ConditionalOnClass(value={MongoProperties.class, TransmittableThreadLocal.class})
    public static class MongoDbDataSourceConfigurer {
        @Bean
        public SpecifiedBeanPostProcessor<MongoProperties> perfTestMongoDbDataSourcePostProcessor() {
            return new SpecifiedBeanPostProcessor<MongoProperties>(){

                public int getOrder() {
                    return -2;
                }

                public Class<MongoProperties> getBeanType() {
                    return MongoProperties.class;
                }

                public Object postProcessBeforeInitialization(MongoProperties bean, String beanName) throws BeansException {
                    return bean;
                }

                public Object postProcessAfterInitialization(MongoProperties bean, String beanName) throws BeansException {
                    ConnectionString connectionString = new ConnectionString(bean.getUri());
                    SpringDataMongodbPerfAspect.ORIGIN_DATA_BASE_URI.put(connectionString.getDatabase(), bean.getUri());
                    return bean;
                }
            };
        }
    }

    @Configuration
    @ConditionalOnResource(resources={"classpath:autoconfig/perftest.properties"})
    @ConditionalOnClass(value={TransmittableThreadLocal.class, MongoTemplate.class, Aspect.class})
    public static class SpringDataMongodbPerfConfiguration {
        @Bean
        public SpringDataMongodbPerfAspect getSpringDataMongodbPerfAspect() {
            return new SpringDataMongodbPerfAspect();
        }
    }
}

