/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.data.mongodb.perftest;

import cn.com.duiba.boot.perftest.InternalPerfTestContext;
import cn.com.duiba.boot.perftest.PerfTestContext;
import com.mongodb.ConnectionString;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;

@Aspect
public class SpringDataMongodbPerfAspect {
    public static final Map<String, String> ORIGIN_DATA_BASE_URI = new ConcurrentHashMap<String, String>();
    private final ConcurrentHashMap<String, MongoTemplate> mongoTemplateConcurrentHashMap = new ConcurrentHashMap();

    @Around(value="execution(* org.springframework.data.mongodb.core.MongoTemplate.*(..))")
    public Object springDataMongodbJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        MongoTemplate origin = (MongoTemplate)joinPoint.getTarget();
        Object[] args = joinPoint.getArgs();
        String dbName = origin.getDb().getName();
        if (InternalPerfTestContext.isCurrentInPerfTestMode()) {
            if (!this.mongoTemplateConcurrentHashMap.containsKey(dbName)) {
                ConnectionString connectionString = new ConnectionString(ORIGIN_DATA_BASE_URI.get(dbName));
                String originDataBaseName = connectionString.getDatabase();
                SimpleMongoClientDatabaseFactory shadeFactory = new SimpleMongoClientDatabaseFactory(ORIGIN_DATA_BASE_URI.get(dbName).replace("/" + originDataBaseName + "?", "/perf__" + originDataBaseName + "?"));
                this.mongoTemplateConcurrentHashMap.put(dbName, new MongoTemplate((MongoDatabaseFactory)shadeFactory));
            }
            PerfTestContext.debugInfo((String)"MongoTemplate");
            return signature.getMethod().invoke((Object)this.mongoTemplateConcurrentHashMap.get(dbName), args);
        }
        return joinPoint.proceed(args);
    }
}

