package cn.com.duibaboot.ext.autoconfigure.rocketmq.grouping;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.duiba.ConsumerProperties;
import com.google.common.base.Throwables;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.common.message.MessageExt;
import org.springframework.beans.factory.BeanNameAware;

import java.util.List;

/**
 * RocketMQ MessageListener的包装，增加cat监控
 */
public class MessageListenerOrderlyWrapper implements MessageListenerOrderly, BeanNameAware {

    private MessageListenerOrderly source;

    private String beanName;

    private ConsumerProperties consumerProperties;

    public MessageListenerOrderlyWrapper(MessageListenerOrderly source, String beanName) {
        this.source = source;
        this.beanName = beanName;
    }

    @Override
    public ConsumeOrderlyStatus consumeMessage(List<MessageExt> msgs, ConsumeOrderlyContext context) {
        DBTimeProfile.start();
        try {
            return CatUtils.executeInCatTransaction(() -> source.consumeMessage(msgs, context), "MessageQueue", "RocketMQ.consume");
        } catch (Throwable e) {
            throw Throwables.propagate(e);
        } finally {
            DBTimeProfile.end("RocketMQ.consume");
        }
    }

    @Override
    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return beanName;
    }

    public ConsumerProperties getConsumerProperties() {
        return consumerProperties;
    }

    public void setConsumerProperties(ConsumerProperties consumerProperties) {
        this.consumerProperties = consumerProperties;
    }
}
