/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.rocketmq.sleuth;

import cn.com.duibaboot.ext.autoconfigure.rocketmq.sleuth.RocketmqSleuthContext;
import java.util.List;
import java.util.Objects;
import org.apache.rocketmq.client.hook.ConsumeMessageContext;
import org.apache.rocketmq.client.hook.ConsumeMessageHook;

public class RocketmqSleuthConsumeMessageHook
implements ConsumeMessageHook {
    private final ThreadLocal<RocketmqSleuthContext> contextThreadLocal = new ThreadLocal();

    public String hookName() {
        return "sleuth-hook";
    }

    protected RocketmqSleuthContext getRocketmqSleuthContext() {
        return this.contextThreadLocal.get();
    }

    public void consumeMessageBefore(ConsumeMessageContext context) {
        List messages = context.getMsgList();
        if (Objects.isNull(messages) || messages.isEmpty()) {
            return;
        }
        RocketmqSleuthContext sleuthContext = new RocketmqSleuthContext();
        sleuthContext.initContext(messages);
        this.contextThreadLocal.set(sleuthContext);
    }

    public void consumeMessageAfter(ConsumeMessageContext context) {
        this.contextThreadLocal.remove();
    }
}

